//
//  YHTwoOptionAlertView.swift
//  galaxy
//
//  Created by edy on 2024/2/1.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHTwoOptionAlertView: UIView {
    
        typealias Block = (Bool) -> ()
        var block: Block?
        var centerView: UIView!
        var messageLabel: UILabel!
        var rightButton: UIButton!
        var leftButton: UIButton!
        
        static func showAlertView(message:String?,leftBtnTitle:String? = "取消".local, rightBtnTitle:String? = "确认".local, callBack: @escaping Block) {
            
            let view = YHTwoOptionAlertView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
            view.messageLabel.text = message
            view.leftButton.setTitle(leftBtnTitle, for: .normal)
            view.rightButton.setTitle(rightBtnTitle, for: .normal)
            view.block = callBack
            let window = UIApplication.shared.yhKeyWindow()
            window?.addSubview(view)
        }
        
        override init(frame: CGRect) {
            super.init(frame: frame)
            backgroundColor = UIColor(white: 0.5, alpha: 0.1)
            let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
            tap.delegate = self
            addGestureRecognizer(tap)
            setView()
        }
        
        required init?(coder: NSCoder) {
            fatalError("init(coder:) has not been implemented")
        }
        
        func setView() {
            backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
            centerView = {
                let view = UIView()
                view.backgroundColor = .white
                view.layer.cornerRadius = kCornerRadius6
                return view
            }()
            addSubview(centerView)
            
            messageLabel = {
                let label = UILabel()
                label.text = ""
                label.font = UIFont.PFSC_R(ofSize: 16)
                label.textColor = UIColor.mainTextColor
                label.textAlignment = .center
                label.numberOfLines = 0
                return label
            }()
            centerView.addSubview(messageLabel)
            
            leftButton = {
                let button = UIButton(type: .custom)
                button.backgroundColor =  UIColor(hex:0xffffff)
                button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
                button.contentHorizontalAlignment = .center
                button.setTitle("取消".local, for: .normal)
                button.setTitleColor( UIColor.brandMainColor, for: .normal)
                button.layer.cornerRadius = kCornerRadius3
                button.layer.borderWidth = 1
                button.layer.borderColor = UIColor.brandMainColor.cgColor
                button.addTarget(self, action: #selector(disagree), for: .touchUpInside)
                return button
            }()
            centerView.addSubview(leftButton)
            
            rightButton = {
                let button = UIButton(type: .custom)
                button.backgroundColor =  UIColor.brandMainColor
                button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
                button.contentHorizontalAlignment = .center
                button.setTitle("确认".local, for: .normal)
                button.setTitleColor( UIColor(hex:0xffffff), for: .normal)
                button.layer.cornerRadius = kCornerRadius3
                button.addTarget(self, action: #selector(agree), for: .touchUpInside)
                return button
            }()
            centerView.addSubview(rightButton)
            
            centerView.snp.makeConstraints { make in
                make.center.equalToSuperview()
                make.width.equalTo(299)
            }
            
            messageLabel.snp.makeConstraints { make in
                make.top.equalTo(40)
                make.left.equalTo(22)
                make.right.equalTo(-22)
            }
            leftButton.snp.makeConstraints { make in
                make.top.equalTo(messageLabel.snp.bottom).offset(40)
                make.left.equalTo(16)
                make.bottom.equalToSuperview().offset(-16)
                make.size.equalTo(CGSize(width: 128, height: 45))
            }
            
            rightButton.snp.makeConstraints { make in
                make.right.equalTo(-16)
                make.centerY.equalTo(leftButton)
                make.size.equalTo(CGSize(width: 128, height: 45))
            }
        }
        
        @objc func agree() {
            block?(true)
            dismiss()
        }
        
        @objc private func handleTap(_ sender: AnyObject?) {
            print("处理点击手势")
            dismiss()
        }
        
        @objc func disagree() {
            block?(false)
            dismiss()
        }
        
        func dismiss() {
            removeFromSuperview()
        }
}

extension YHTwoOptionAlertView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer:UIGestureRecognizer, shouldReceive touch:UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}

