//
//  YHActivityDetailCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/6/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHActivityDetailCell: UITableViewCell {
    static let cellReuseIdentifier = "YHActivityDetailCell"
    
    
    var dataModel : YHActivityDetailModel? {
        didSet {
            updateUI()
        }
    }
    
   
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    lazy var topImgV:UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "global_default_image")
        view.contentMode = .scaleAspectFill
        view.clipsToBounds = true
        return view
    }()
    
    
    //活动名称地址
    lazy var acitivityTitle:YHActivityTitleItemView = {
        let view = YHActivityTitleItemView()
        return view
    }()
    
    
    //活动详情
    lazy var acitivityDetail:YHActivityDetailItemView = {
        let view = YHActivityDetailItemView()
        return view
    }()
    
    //活动温馨提示
    lazy var acitivityTips:YHActivityTipsItemView = {
        let view = YHActivityTipsItemView()
        return view
    }()
    
    
    //活动温馨提示
    lazy var fakeView:UIView = {
        let view = UIView()
        view.backgroundColor = .clear
        return view
    }()
}

extension YHActivityDetailCell {
    func updateUI() {
        guard let model = dataModel else  {
            return
        }
        
        contentView.removeSubviews()
        contentView.addSubview(topImgV)
        contentView.addSubview(acitivityTitle)
        contentView.addSubview(acitivityDetail)
        contentView.addSubview(acitivityTips)
        contentView.addSubview(fakeView)
       
        
        topImgV.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(KScreenWidth)
        }
        
        if let url = URL(string: model.cover) {
            topImgV.kf.setImage(with: url, placeholder: UIImage(named: "global_default_image"))
        } else {
            topImgV.image = UIImage(named: "global_default_image")
        }
        
        acitivityTitle.dataModel = model
        acitivityTitle.snp.makeConstraints { make in
            make.top.equalTo(topImgV.snp.bottom).offset(24)
            make.left.equalTo(20)
            make.right.equalTo(-20)
        }
        
        
        var lastView : UIView = acitivityTitle
        
        
        
        //acitivityDetail
        if model.introduce.isEmpty && model.posters.count < 1 {
            //隐藏
            acitivityDetail.isHidden = true
        } else {
            //展示
            acitivityDetail.isHidden = false
            acitivityDetail.dataModel = model
            
            
            acitivityDetail.snp.makeConstraints { make in
                make.top.equalTo(lastView.snp.bottom).offset(24)
                make.left.equalTo(20)
                make.right.equalTo(-20)
            }
            
            lastView = acitivityDetail
        }
        
        //acitivityTips
        if model.tips.isEmpty {
            acitivityTips.isHidden = true
        } else {
            acitivityTips.isHidden = false
            acitivityTips.dataModel = model
            
            acitivityTips.snp.makeConstraints { make in
                make.top.equalTo(lastView.snp.bottom).offset(24)
                make.left.equalTo(20)
                make.right.equalTo(-20)
            }
            lastView = acitivityTips
        }
        
        fakeView.snp.makeConstraints { make in
            make.top.equalTo(lastView.snp.bottom).offset(24)
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.height.equalTo(1)
            make.bottom.equalToSuperview().offset(-42)
        }
        
        
        
        
    }
    
    func setupUI() {
        backgroundColor = .clear
        contentView.backgroundColor = .pageBkgColor
        selectionStyle = .none
    }
}
