//
//  YHActivityTravelitemView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/6/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
class YHActivityTravelitemView: UIView {
    
    var dataModel : YHActivityTravelModel? {
        didSet {
            updateUI()
        }
    }
    

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    lazy var activityImgV:UIImageView = {
        let view = UIImageView()
        view.contentMode = .scaleAspectFill
        view.image = UIImage(named: "global_default_image")
        return view
    }()
    
    lazy var nameLabel:UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .left
        label.font = UIFont.PFSC_M(ofSize:18)
        label.text = ""
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    
    lazy var timeStaticLable:UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor50
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize:14)
        label.text = "时间"
        return label
    }()
    
    lazy var timeLable:UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize:14)
        label.text = "2024-08-06 周五  09:30"
        label.numberOfLines = 0
        return label
    }()
    
    lazy var addressStaticLable:UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor50
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize:14)
        label.text = "地址"
        return label
    }()
    
    
    lazy var addressLable:UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize:14)
        label.text = ""
        label.numberOfLines = 0
        return label
    }()
    
    
    lazy var navAddressLable:UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor50
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize:14)
        label.text = ""
        label.numberOfLines = 0
        return label
    }()
}


extension YHActivityTravelitemView {
    
    @objc func goActiveDetailVC(gestureRecognizer:UITapGestureRecognizer) {
        
        guard let model = dataModel else  {
            return
        }
        
        if let pvc = self.parentViewController,let nav = pvc.navigationController {
            let rrr = nav.viewControllers.contains { $0.isKind(of: YHActivityDetailViewController.self) }
            if rrr {
                
                var  targetVc : UIViewController?
                for(_,value) in nav.viewControllers.enumerated() {
                    if value.isKind(of: YHActivityDetailViewController.self) {
                        targetVc = value
                        break
                    }
                }
                
                if let vc = targetVc {
                    pvc.navigationController?.popToViewController(vc, animated: true)
                }
                return
            }
            
            
            
            let vc = YHActivityDetailViewController()
            vc.activityId = String(model.id)
            vc.activityName = model.name
            pvc.navigationController?.pushViewController(vc)
        }
    }
    
    
    func updateUI() {
        guard let model = dataModel else  {
            return
        }
        
        nameLabel.text = model.name
        
        if let url = URL(string: model.cover) {
            activityImgV.kf.setImage(with: url, placeholder: UIImage(named: "global_default_image"))
        } else {
            activityImgV.image = UIImage(named: "global_default_image")
        }
        
        timeLable.text = model.getDateString(format: "yyyy-MM-dd")
        addressLable.text = model.place
        navAddressLable.text = model.guidance
        
        
        
        let hhhh = nameLabel.requiredHeight
        
        
        timeStaticLable.snp.removeConstraints()
        if hhhh > 72 {
            timeStaticLable.snp.remakeConstraints { make in
                make.left.equalTo(nameLabel.snp.left)
                make.top.equalTo(nameLabel.snp.bottom).offset(24)
                make.height.equalTo(20)
                make.width.equalTo(28)
            }
        } else {
            timeStaticLable.snp.remakeConstraints { make in
                make.left.equalTo(nameLabel.snp.left)
                make.top.equalTo(activityImgV.snp.bottom).offset(24)
                make.height.equalTo(20)
                make.width.equalTo(28)
            }
        }
        
        
        
        timeLable.snp.remakeConstraints { make in
            make.left.equalTo(timeStaticLable.snp.right).offset(16)
            make.top.equalTo(timeStaticLable.snp.top)
            make.right.equalToSuperview().offset(-20)
        }
    
        addressStaticLable.snp.remakeConstraints { make in
            make.left.equalTo(timeStaticLable.snp.left)
            make.top.equalTo(timeLable.snp.bottom).offset(13)
            make.height.equalTo(timeStaticLable.snp.height)
            make.width.equalTo(timeStaticLable.snp.width)
        }
        
        addressLable.snp.remakeConstraints { make in
            make.left.equalTo(timeLable.snp.left)
            make.top.equalTo(addressStaticLable.snp.top)
            make.right.equalToSuperview().offset(-20)
        }
        
        
        navAddressLable.snp.remakeConstraints { make in
            make.left.equalTo(addressLable.snp.left)
            make.top.equalTo(addressLable.snp.bottom).offset(8)
            make.right.equalToSuperview().offset(-20)
            
            make.bottom.equalToSuperview().offset(-20)
        }
        
        
        
        let tap : UITapGestureRecognizer = UITapGestureRecognizer(target: self, action: #selector(goActiveDetailVC(gestureRecognizer:)))
        activityImgV.addGestureRecognizer(tap)
        activityImgV.isUserInteractionEnabled = true
        
        let tap1 : UITapGestureRecognizer = UITapGestureRecognizer(target: self, action: #selector(goActiveDetailVC(gestureRecognizer:)))
        nameLabel.addGestureRecognizer(tap1)
        nameLabel.isUserInteractionEnabled = true
    }
    
    func setupUI() {
        
        backgroundColor = .white
        layer.cornerRadius = kCornerRadius6
        clipsToBounds = true
        
        addSubview(activityImgV)
        addSubview(nameLabel)
        addSubview(timeStaticLable)
        addSubview(timeLable)
        addSubview(addressStaticLable)
        addSubview(addressLable)
        addSubview(navAddressLable)
        
        
        activityImgV.snp.makeConstraints { make in
            make.top.equalTo(20)
            make.right.equalTo(-20)
            make.height.width.equalTo(72)
        }
        
        nameLabel.snp.makeConstraints { make in
            make.top.equalTo(24)
            make.left.equalTo(20)
            make.right.equalTo(activityImgV.snp.left).offset(-42)
        }
        
        timeStaticLable.snp.makeConstraints { make in
            make.left.equalTo(nameLabel.snp.left)
            make.top.equalTo(activityImgV.snp.bottom).offset(24)
            make.height.equalTo(20)
            make.width.equalTo(28)
        }
        
        timeLable.snp.makeConstraints { make in
            make.left.equalTo(timeStaticLable.snp.right).offset(16)
            make.top.equalTo(timeStaticLable.snp.top)
            make.right.equalToSuperview().offset(-20)
        }
    
        addressStaticLable.snp.makeConstraints { make in
            make.left.equalTo(timeStaticLable.snp.left)
            make.top.equalTo(timeLable.snp.bottom).offset(13)
            make.height.equalTo(timeStaticLable.snp.height)
            make.width.equalTo(timeStaticLable.snp.width)
        }
        
        addressLable.snp.makeConstraints { make in
            make.left.equalTo(timeLable.snp.left)
            make.top.equalTo(addressStaticLable.snp.top)
            make.right.equalToSuperview().offset(-20)
        }
        
        
        navAddressLable.snp.makeConstraints { make in
            make.left.equalTo(addressLable.snp.left)
            make.top.equalTo(addressLable.snp.bottom).offset(8)
            make.right.equalToSuperview().offset(-20)
            
            make.bottom.equalToSuperview().offset(-20)
        }
        
    }
}
