//
//  YHMyIntroductionCell.swift
//  galaxy
//
//  Created by edy on 2024/6/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMyIntroductionCell: UITableViewCell {
    typealias EditBlock = () -> ()
    var editBlock: EditBlock?
    static let cellReuseIdentifier = "YHMyIntroductionCell"
    
    var userModel:YHUserNameCardInfo = YHUserNameCardInfo() {
        didSet {
            
            self.editBtn.isHidden = !self.userModel.isCurrentUser

            if userModel.type == .introduce {
                self.titleLabel.text =  "个人简介"
                self.detailLabel.textColor = UIColor.mainTextColor70
                if !self.userModel.bio.isEmpty {
                    self.detailLabel.text = self.userModel.bio
                } else {
                    self.detailLabel.text = ""
                    if self.userModel.isCurrentUser {
                        self.detailLabel.text = "快来完善你的个人简介，用简洁的文字描绘你的独特魅力。"
                        self.detailLabel.textColor = UIColor.mainTextColor30
                    }
                }
                

            } else if userModel.type == .honor {
                self.titleLabel.text =  "荣誉奖项"
                self.detailLabel.textColor = UIColor.mainTextColor70
                if !self.userModel.honor.isEmpty {
                    self.detailLabel.text = self.userModel.honor
                } else {
                    self.detailLabel.text = ""
                    if self.userModel.isCurrentUser {
                        self.detailLabel.text = "展示你的辉煌时刻，让更多人见证你的卓越成就！"
                        self.detailLabel.textColor = UIColor.mainTextColor30
                    }
                }
            }
        }
    }
    lazy var cardView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = 6.0
        view.clipsToBounds = true
        return view
    }()
    
    lazy var titleLabel:UILabel = {
        let label = UILabel()
        label.text = "个人简介"
        label.textColor = UIColor(hexString: "#222222")
        label.textAlignment = .left
        label.font = UIFont.PFSC_M(ofSize:17)
        return label
    }()
    
    lazy var detailLabel:UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor70
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize:14)
        label.numberOfLines = 0
        return label
    }()
    
    lazy var editBtn:UIButton = {
        let btn = UIButton()
        btn.setImage(UIImage(named: "people_card_edit"), for: .normal)
        btn.addTarget(self, action: #selector(edit), for: .touchUpInside)
        btn.YH_clickEdgeInsets = UIEdgeInsets(top: 20, left: 20, bottom: 20, right: 20)
        return btn
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
       
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        
        self.contentView.addSubview(self.cardView)
        cardView.addSubview(self.titleLabel)
        cardView.addSubview(self.detailLabel)
        cardView.addSubview(self.editBtn)
        
        cardView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(16)
            make.height.equalTo(24)
        }
        
        editBtn.snp.makeConstraints { make in
            make.width.height.equalTo(20)
            make.right.equalTo(-15)
            make.centerY.equalTo(titleLabel)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.top.equalTo(self.titleLabel.snp.bottom).offset(12)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(-16)
        }
    }
    
    @objc func edit() {
        if let block = editBlock {
            block()
        }
    }
}
