//
//  YHAiRadarAreaView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/6/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import Lottie

class YHAiRadarAreaView: UIView {

    static let viewH = 88.0
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
        
        let tap : UITapGestureRecognizer = UITapGestureRecognizer(target: self, action: #selector(tapButton(gestureRecognizer:)))
        addGestureRecognizer(tap)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var bkgImageV: UIImageView = {
        let imgV : UIImageView = UIImageView()
        imgV.contentMode = .scaleAspectFill
        imgV.image = UIImage(named: "home_radar_bkg")
        imgV.clipsToBounds = true
        return imgV
    }()
    
    
    lazy var lable1: UILabel = {
        let lable : UILabel = UILabel()
        lable.text = "AI人脉雷达"
        lable.font = UIFont.PFSC_B(ofSize: 17)
        lable.textColor = UIColor.mainTextColor
        return lable
    }()
    
    
    lazy var lable2: UILabel = {
        let lable : UILabel = UILabel()
        lable.text = "为您找到更多同行"
        lable.font = UIFont.PFSC_R(ofSize: 12)
        lable.textColor = UIColor.yhGreyColor
        return lable
    }()
    
    
    lazy var lable3: UILabel = {
        let lable : UILabel = UILabel()
        lable.text = "前往查看"
        lable.font = UIFont.PFSC_R(ofSize: 13)
        lable.textColor = UIColor.white
        lable.backgroundColor = UIColor.brandMainColor
        lable.textAlignment = .center
        return lable
    }()
    
    lazy var animationView: LottieAnimationView = {
        let view = LottieAnimationView(name: "data")
        view.loopMode = .loop
        view.play()
        return view
    }()
}

extension YHAiRadarAreaView {
    
    @objc func tapButton(gestureRecognizer:UITapGestureRecognizer) {
        goTabBarBy(tabType: .community)
        DispatchQueue.main.async {
            NotificationCenter.default.post(name: YhConstant.YhNotification.goConnectionVCNotifiction, object: nil)
        }
    }
    
    func setupUI() {
        addSubview(bkgImageV)
        bkgImageV.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        
        addSubview(animationView)
        animationView.snp.makeConstraints { make in
            make.width.height.equalTo(54)
            make.left.equalTo(20)
            make.centerY.equalToSuperview()
        }
        
        addSubview(lable1)
        lable1.snp.makeConstraints { make in
            make.top.equalTo(22)
            make.left.equalTo(animationView.snp.right).offset(kMargin)
            make.height.equalTo(22)
        }
        
        
        
        addSubview(lable2)
        lable2.snp.makeConstraints { make in
            make.top.equalTo(lable1.snp.bottom).offset(4)
            make.left.equalTo(lable1.snp.left)
            make.height.equalTo(17)
        }
        
        
        addSubview(lable3)
        lable3.snp.makeConstraints { make in
            make.right.equalTo(-24)
            make.centerY.equalToSuperview()
            make.width.equalTo(76)
            make.height.equalTo(34)
        }
    }
}
