//
//  YHHkLifeAndIdView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
/*
 香港身份 香港生活
 */
class YHHkLifeAndIdView: UIView {
    static let viewH : CGFloat = 74.0
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}


private extension YHHkLifeAndIdView {
    func initView() {
        
        let itemW : CGFloat = (KScreenWidth - 20 * 2 - 12) / 2.0
        
        let item0 = YHHkLifeAndIdItemView()
        item0.itemType = .hkID
        addSubview(item0)
        item0.snp.makeConstraints { make in
            make.top.left.equalToSuperview()
            make.height.equalTo(YHHkLifeAndIdView.viewH)
            make.width.equalTo(itemW)
        }
        
        let item1 = YHHkLifeAndIdItemView()
        item1.itemType = .hklife
        addSubview(item1)
        item1.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.left.equalTo(item0.snp.right).offset(12)
            make.height.equalTo(YHHkLifeAndIdView.viewH)
            make.width.equalTo(itemW)
        }
    }
}
