//
//  YHHomeBannerCollectionViewCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import FSPagerView

import CoreImage
import VisualEffectView

class YHHomeBannerCollectionViewCell: FSPagerViewCell {
    override init(frame: CGRect) {
        super.init(frame: frame)
        textLabel?.text = ""
        textLabel?.isHidden = true
        imageView?.isHidden = true
        
        initView()
    }
    
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var bannerImagV: UIImageView = {
        let imagV : UIImageView = UIImageView()
        imagV.contentMode = .scaleAspectFill
        imagV.clipsToBounds = true
        imagV.image = UIImage(named: "global_default_image")
        return imagV
    }()
    
    lazy var bannerTitleLable: UILabel = {
        let lable = UILabel()
        lable.font = UIFont.PFSC_R(ofSize: 16)
        lable.textColor = UIColor.white
        return lable
    }()
    
    var dataModel : YHBannerModel? {
        didSet {
            updateUI()
        }
    }
    let visualEffectView = VisualEffectView()
}

private extension YHHomeBannerCollectionViewCell {
    
    func initView() {
        contentView.addSubview(bannerImagV)
        bannerImagV.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
             
        // Configure the view with tint color, blur radius, etc
        visualEffectView.colorTint = UIColor(hex: 0xAFAFAF).withAlphaComponent(0.15)
        visualEffectView.blurRadius = 16
        visualEffectView.scale = 1
        contentView.addSubview(visualEffectView)
        visualEffectView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(77)
        }
        
        contentView.addSubview(bannerTitleLable)
        bannerTitleLable.snp.makeConstraints { make in
            make.right.equalTo(-20)
            make.bottom.equalTo(-35)
            make.left.equalTo(20)
            make.height.equalTo(22)
        }
    }
    
    func updateUI() {
        guard let model = dataModel else { return }
        
        if model.isLocalItemFlag {
            bannerTitleLable.isHidden = true
            visualEffectView.isHidden = true
            
            bannerImagV.image = UIImage(named: model.img_url)
        } else {
            bannerTitleLable.isHidden = false
            visualEffectView.isHidden = false
            
            if let url = URL(string: model.img_url) {
                if let avifUrl = URL(string: model.img_url_compress) {
                    bannerImagV.kf.setImage(with: avifUrl, placeholder: UIImage(named: "global_default_image")) { result in
                        switch result {
                        case .success: break
                        case .failure(let error):
                            self.bannerImagV.kf.setImage(with: url, placeholder: UIImage(named: "global_default_image"))
                        }
                    }
                } else {
                    bannerImagV.kf.setImage(with: url, placeholder: UIImage(named: "global_default_image"))
                }
            } else {
                bannerImagV.image = UIImage(named: "global_default_image")
            }
            bannerTitleLable.text = model.name
        }
    }
}
