//
//  YHHomeHeadView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/7.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
class YHHomeHeadView: UIView {
    
    // 不包含订单提示视图的总高度
    static let fixViewH : CGFloat = (YHHomeBannerView.viewH) + (20 + YHHomeKingKongBlockView.viewH) + (20 + 1) + (20 + YHAiRadarAreaView.viewH) + (20 + YHHomeSalonAreaView.viewH) + (20 + 1) + 20
    
    // 包含订单提示视图的总高度
//    private static let viewHWithOrderTips: CGFloat = YHHomeHeadView.fixViewH + (20 + YHOrderTipsView.viewH)
    
    var homeHeadViewH : CGFloat {
        return YHHomeHeadView.fixViewH + (20 + orderTipsView.tipViewH)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    //1.bannner
    lazy var homeBannerView : YHHomeBannerView = {
        let view = YHHomeBannerView()
        return view
    }()
    
//    //2.香港身份 香港生活
//    lazy var homeHkLife : YHHkLifeAndIdView = {
//        let view = YHHkLifeAndIdView()
//        return view
//    }()
    
    //3. 四大金刚区
    lazy var homeKingKongBlock : YHHomeKingKongBlockView = {
        let view = YHHomeKingKongBlockView()
        return view
    }()
    
    lazy var bannerLineTop : UIView = {
        let line = UIView()
        line.backgroundColor = UIColor(hex: 0xF0F3F7, alpha: 1.0)
        return line
    }()
    
    
    //4.优才订单提示视图  - 未登录态不
    lazy var orderTipsView: YHOrderTipsView = {
        let view = YHOrderTipsView(frame: .zero)
        view.isHidden = true
        return view
    }()
    
    
    //5. ai人脉雷达
    lazy var aiRadarArea: YHAiRadarAreaView = {
        let view = YHAiRadarAreaView(frame: .zero)
        return view
    }()
    
    
    //6.银河线下沙龙
    lazy var salonArea: YHHomeSalonAreaView = {
        let view = YHHomeSalonAreaView(frame: .zero)
        return view
    }()
    
    
    
    lazy var bannerLineBottom : UIView = {
        let line = UIView()
        line.backgroundColor = UIColor(hex: 0xF0F3F7, alpha: 1.0)
        return line
    }()
    
    
    
    // 是否隐藏优才订单提示视图
    var isNeedHideOrderTipsView:Bool = true {
        didSet {
            self.orderTipsView.isHidden = isNeedHideOrderTipsView
//            self.aiRadarArea.snp.updateConstraints { make in
//                let topMargin = isNeedHideOrderTipsView ? 20.0 : 20.0 + orderTipsView.tipViewH + 20.0
//                make.top.equalTo(bannerLineTop.snp.bottom).offset(topMargin)
//            }
//            self.setNeedsLayout()
//            self.layoutIfNeeded()
            updateSubViewsConstraints()
        }
    }
    
    
//    override func layoutSubviews() {
//        super.layoutSubviews()
//    }
    
    func updateSubViewsConstraints() {
        homeBannerView.snp.remakeConstraints { make in
            make.top.equalTo(0)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHHomeBannerView.viewH)
        }
//        homeHkLife.snp.remakeConstraints { make in
//            make.top.equalTo(homeBannerView.snp.bottom).offset(20)
//            make.left.right.equalToSuperview()
//            make.height.equalTo(YHHkLifeAndIdView.viewH)
//        }
        homeKingKongBlock.snp.remakeConstraints { make in
            make.top.equalTo(homeBannerView.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHHomeKingKongBlockView.viewH)
        }
        bannerLineTop.snp.remakeConstraints { make in
            make.top.equalTo(homeKingKongBlock.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(1)
        }
        
        
        orderTipsView.snp.removeConstraints()
        if self.orderTipsView.isHidden {
            aiRadarArea.snp.remakeConstraints { make in
                make.top.equalTo(bannerLineTop.snp.bottom).offset(20)
                make.left.right.equalToSuperview()
                make.height.equalTo(YHAiRadarAreaView.viewH)
            }
            
        } else {
            
            orderTipsView.isHidden = false
            orderTipsView.snp.remakeConstraints { make in
                make.top.equalTo(bannerLineTop.snp.bottom).offset(20)
                make.left.right.equalToSuperview()
                make.height.equalTo(orderTipsView.tipViewH)
            }
            
            
            aiRadarArea.snp.remakeConstraints { make in
                make.top.equalTo(orderTipsView.snp.bottom).offset(20)
                make.left.right.equalToSuperview()
                make.height.equalTo(YHAiRadarAreaView.viewH)
            }
        }
        
        
        salonArea.snp.remakeConstraints { make in
            make.top.equalTo(aiRadarArea.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHHomeSalonAreaView.viewH)
        }
        bannerLineBottom.snp.remakeConstraints { make in
            make.top.equalTo(salonArea.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(1)
        }
    }
}

private extension YHHomeHeadView {
    func initView() {
        backgroundColor = .clear
        
        addSubview(homeBannerView)
        homeBannerView.snp.makeConstraints { make in
            make.top.equalTo(0)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHHomeBannerView.viewH)
        }
        
//        addSubview(homeHkLife)
//        homeHkLife.snp.makeConstraints { make in
//            make.top.equalTo(homeBannerView.snp.bottom).offset(20)
//            make.left.right.equalToSuperview()
//            make.height.equalTo(YHHkLifeAndIdView.viewH)
//        }
        
        addSubview(homeKingKongBlock)
        homeKingKongBlock.snp.makeConstraints { make in
            make.top.equalTo(homeBannerView.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHHomeKingKongBlockView.viewH)
        }
        
        addSubview(bannerLineTop)
        bannerLineTop.snp.makeConstraints { make in
            make.top.equalTo(homeKingKongBlock.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(1)
        }
        
        addSubview(orderTipsView)
        orderTipsView.snp.makeConstraints { make in
            make.top.equalTo(bannerLineTop.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(226)
//            make.height.equalTo(orderTipsView.tipViewH)
        }
        
        
        addSubview(aiRadarArea)
        aiRadarArea.snp.makeConstraints { make in
            make.top.equalTo(bannerLineTop.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHAiRadarAreaView.viewH)
        }
        
        addSubview(salonArea)
        salonArea.snp.makeConstraints { make in
            make.top.equalTo(aiRadarArea.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHHomeSalonAreaView.viewH)
        }
        
        addSubview(bannerLineBottom)
        bannerLineBottom.snp.makeConstraints { make in
            make.top.equalTo(salonArea.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(1)
        }
        
        
        
    }
}
