//
//  YHOrderTipsItemView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/6/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHOrderTipsItemView: UIView {
    static let viewH = 52.0
    
    var message : YHHomeLastMessageModel? {
        didSet {
            updateData()
        }
    }
    
    var indexItem : Int = 0
    
    func getTypeString() -> String {
        if let msg = self.message {
            if msg.type == YHMessageType.infoFill.rawValue {
                return "资料填写"
                
            } else if msg.type == YHMessageType.cerUpload.rawValue {
                return "证件上传"
                
            } else if msg.type == YHMessageType.draft.rawValue {
                return "文书定稿"
                
            } else if msg.type == YHMessageType.fileSign.rawValue {
                return "文件签字"
                
            } else if msg.type == YHMessageType.infoSubmit.rawValue {
                return "资料递交"
            }  else {
                return "--"
            }
        }
       
        return "-"
    }
    
    func updateData() {
        guard let message = message else { return }
        
        
        let typeString = self.getTypeString()
        lableMyOrder.text = typeString
        lableName.text = message.content
        if indexItem == 1 {
            lableTime.text = "最新消息"
        } else {
            lableTime.text = getTimeString(data: TimeInterval(message.time))
        }
        
    }
    
    func getTimeString(data: TimeInterval) -> String {
        let timestamp = Date().timeIntervalSince1970
        let distance = timestamp - data
        if distance < 60 {
            return "最新消息" //1分钟内
        } else if distance < 60 * 60 {
            
            let time = (distance/60).int
            return "\(time)分钟前" //60分钟
        } else if distance < 24 * 60 * 60 {
            
            let time = (distance/60/60).int
            return "\(time)小时前" //
        } else if distance < 48 * 60 * 60 {
            
            return "昨天"
        } else {
            // 将TimeInterval转换为Date
            let date = Date(timeIntervalSince1970: data)
            // 创建一个DateFormatter来格式化日期
            let formatter = DateFormatter()
            formatter.dateFormat = "MM-dd" // 设置日期格式
            formatter.locale = Locale(identifier: "en_US_POSIX") // 设置地区，避免时区问题
            // 将Date转换为字符串
            let dateString = formatter.string(from: date)
            return dateString
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    //文书定稿
    lazy var lableMyOrder: UILabel = {
        let lable : UILabel = UILabel()
        lable.text = "文书定稿"
        lable.font = UIFont.PFSC_R(ofSize: 13)
        lable.textColor = UIColor.mainTextColor
        return lable
    }()
    
    
    //分割线
    lazy var segmentationView: UIView = {
        let view : UIView = UIView()
        view.backgroundColor = UIColor.mainTextColor18
        return view
    }()
    
    
    
    //右箭头
    lazy var rightIconImageV: UIImageView = {
        let imgV : UIImageView = UIImageView()
        imgV.contentMode = .scaleAspectFill
        imgV.image = UIImage(named: "home_order_tips_right_arrow")
        return imgV
    }()
    
    
    //您有2份证件需要签...
    lazy var lableName: UILabel = {
        let lable : UILabel = UILabel()
        lable.text = "您有2份证件需要签"
        lable.font = UIFont.PFSC_R(ofSize: 13)
        lable.textColor = UIColor.mainTextColor70
        lable.lineBreakMode = .byTruncatingTail
        return lable
    }()
    
    
    
    //20分钟前
    lazy var lableTime: UILabel = {
        let lable : UILabel = UILabel()
        lable.text = "20分钟前"
        lable.font = UIFont.PFSC_R(ofSize: 12)
        lable.textColor = UIColor.yhGreyColor
        lable.textAlignment = .right
        return lable
    }()
}


extension YHOrderTipsItemView {
    @objc func tapButton(gestureRecognizer:UITapGestureRecognizer) {
        
        if let msg = self.message {
            let vc = YHMessageDetailListVC()
            vc.type = Int(msg.type)
            vc.title = self.getTypeString()
            UIViewController.current?.navigationController?.pushViewController(vc)
            
            NotificationCenter.default.post(name: YhConstant.YhNotification.clickHomeMsgNotifiction, object: nil)
        }
    }
    
    func setupUI() {
        
        let tap = UITapGestureRecognizer(target: self, action: #selector(tapButton(gestureRecognizer:)))
        self.addGestureRecognizer(tap)
        
        backgroundColor = UIColor(hex: 0xffffff, alpha: 0.65)
        layer.borderWidth = 0.5
        layer.borderColor = UIColor.white.cgColor
        
        
        addSubview(lableMyOrder)
        lableMyOrder.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(12)
            make.height.equalTo(18)
            make.width.equalTo(60)
        }
        
        addSubview(segmentationView)
        segmentationView.snp.makeConstraints { make in
            make.left.equalTo(lableMyOrder.snp.right).offset(8)
            make.height.equalTo(10)
            make.width.equalTo(1)
            make.centerY.equalToSuperview()
        }
        
        
        
        
        
        
        addSubview(rightIconImageV)
        rightIconImageV.snp.makeConstraints { make in
            make.right.equalTo(-12)
            make.centerY.equalToSuperview()
            make.width.height.equalTo(12)
        }
        
        
        addSubview(lableTime)
        lableTime.snp.makeConstraints { make in
            make.right.equalTo(rightIconImageV.snp.left)
            make.centerY.equalTo(rightIconImageV)
            make.height.equalTo(18)
            make.width.lessThanOrEqualTo(60)
        }
        
        addSubview(lableName)
        lableName.snp.makeConstraints { make in
            make.left.equalTo(segmentationView.snp.right).offset(8)
            make.height.equalTo(18)
            make.centerY.equalToSuperview()
            make.right.equalTo(lableTime.snp.left).offset(-12)
        }
        
//        let aa: ASAttributedString = .init("您有", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor70))
//        let bb: ASAttributedString = .init("3", .font(UIFont.PFSC_B(ofSize: 13)),.foreground(UIColor.brandMainColor))
//        let cc: ASAttributedString = .init("份证件需要上传份证件需要上传份证件需要上传", .font(UIFont.PFSC_R(ofSize: 13)),.foreground(UIColor.mainTextColor70))
//        lableName.attributed.text = aa+bb+cc
    }
}
