//
//  YHHomeWebViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/4/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHomeWebViewModel : YHBaseViewModel {
    //数据源
    var mainModel :YHWebModel?
}

extension YHHomeWebViewModel {
    //请求web详情
    func getWebDetail(_ id: Int, callBackBlock:@escaping (_ success: Bool, _ error:YHErrorModel?)->()) {
        let params: [String : Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Common.webInfo
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            let dic = json.data
            guard let resultModel = YHWebModel.deserialize(from: dic as? Dictionary) else {
                callBackBlock(false,nil)
                return
            }
            self.mainModel = resultModel
            callBackBlock(true,nil)
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    // type:0取消 1收藏
    func getStar(_ id: Int, _ type: Int, callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let params: [String : Any] = ["operate_type": type,
                                      "article_id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Common.star
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            guard let self = self else { return }
            //1. json字符串 转 对象
            if json.code == 200 {
                let dic = json.data
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            
            callBackBlock(false,err)
        }
    }
    
    // type:0取消 1收藏
    func getLike(_ id: Int, _ type: Int, callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let params: [String : Any] = ["operate_type": type,
                                      "article_id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Common.like
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            guard let self = self else { return }
            //1. json字符串 转 对象
            if json.code == 200 {
                let dic = json.data
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            
            callBackBlock(false,err)
        }
    }
}
