//
//  YHFileListItems.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

let kSupplementIdKey = "supplementId"
let kCheckStatusKey = "checkStatus"
let kCategoryIdKey = "categoryId"

class YHFileListItemsView: UIView {
      
    override init(frame: CGRect) {
        super.init(frame: frame)
    }
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    var dataModel : YHFileListModel? {
        didSet {
            updateUI()
        }
    }
    
    
    private lazy var topBkg : UIView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "file_list_session_bkg")
        imagV.contentMode = .scaleAspectFill
        return imagV
    }()
    
    
    
    private lazy var titleLable : UILabel = {
        let lable0 = UILabel(text: "title")
        lable0.textColor = UIColor.mainTextColor
        lable0.font = UIFont.PFSC_R(ofSize: 18)
        lable0.textAlignment = .center
        return lable0
    }()
}

private extension YHFileListItemsView {
    func updateUI() {
        removeSubviews()
        guard let dataModel = dataModel else { return }
        addSubview(topBkg)
        topBkg.snp.makeConstraints { make in
            make.top.equalTo(22)
            make.centerX.equalToSuperview()
            make.width.equalTo(146)
            make.height.equalTo(28)
        }
        
        titleLable.text = dataModel.ApplicantName.defaultStringIfEmpty(detaultValue: "--")
        addSubview(titleLable)
        titleLable.snp.makeConstraints { make in
            make.top.equalTo(22)
            make.centerX.equalToSuperview()
            make.left.right.equalToSuperview()
            make.height.equalTo(28)
        }
        
        
        if dataModel.supplement_list.isEmpty {
            
            let holdView : UIView = UIView()
            holdView.backgroundColor = UIColor(hex: 0xE5E9F2, alpha: 0.3)
            
            
            addSubview(holdView)
            holdView.snp.makeConstraints { make in
                make.top.equalTo(titleLable.snp.bottom).offset(14)
                make.left.equalToSuperview().offset(kMargin)
                make.right.equalToSuperview().offset(-kMargin)
                make.bottom.equalToSuperview()
                make.height.equalTo(72)
            }
            
            let lable = UILabel()
            lable.text = "暂无待完善清单"
            lable.font = UIFont.PFSC_R(ofSize: 12)
            lable.textColor = UIColor.yhGreyColor
            
            holdView.addSubview(lable)
            lable.snp.makeConstraints { make in
                make.centerX.equalToSuperview()
                make.centerY.equalToSuperview()
            }
            return
        }
        
        
        let holdView : UIView = UIView()
        holdView.layer.cornerRadius = kCornerRadius6
        holdView.clipsToBounds = true
        holdView.layer.borderWidth = 0.5
        holdView.layer.borderColor = UIColor(hex: 0xDEE5F1, alpha: 1.0).cgColor
        
        
        
        addSubview(holdView)
        holdView.snp.makeConstraints { make in
            make.top.equalTo(titleLable.snp.bottom).offset(14)
            make.left.equalToSuperview().offset(kMargin)
            make.right.equalToSuperview().offset(-kMargin)
            make.bottom.equalToSuperview()
        }
        
        let sessionView : UIView = UIView()
        sessionView.backgroundColor = UIColor(hex: 0xE5E9F2, alpha: 0.3)
        holdView.addSubview(sessionView)
        
        if dataModel.supplement_list.isEmpty {
            sessionView.snp.makeConstraints { make in
                make.top.left.right.equalToSuperview()
                make.height.equalTo(38)
                
                make.bottom.equalToSuperview()
            }
        } else {
            sessionView.snp.makeConstraints { make in
                make.top.left.right.equalToSuperview()
                make.height.equalTo(38)
            }
        }
        
        
        let leftLabel : UILabel = UILabel()
        leftLabel.text = "内容"
        leftLabel.font = UIFont.PFSC_R(ofSize: 12)
        leftLabel.textColor = UIColor.labelTextColor2
        
        holdView.addSubview(leftLabel)
        leftLabel.snp.makeConstraints { make in
            make.left.equalTo(40)
            make.top.equalToSuperview()
            make.height.equalTo(38)
        }
        
        
        let rightLabel : UILabel = UILabel()
        rightLabel.text = "状态"
        rightLabel.font = UIFont.PFSC_R(ofSize: 12)
        rightLabel.textColor = UIColor.labelTextColor2
        
        holdView.addSubview(rightLabel)
        rightLabel.snp.makeConstraints { make in
            make.right.equalTo(-34)
            make.top.equalToSuperview()
            make.height.equalTo(38)
        }
        
        
        var lastView : UIView = sessionView
        for (index,item) in dataModel.supplement_list.enumerated() {
            
            let view = YHFileListItemView()
            view.myIndex = index
            view.dataModel = item
            view.clickBlock = {
                model in
                let supplementId = model?.id ?? 0
                let categoryId = self.dataModel?.category_id ?? 0
                let checkStatus = model?.checkStatus ?? -1
                let dict = [kSupplementIdKey: supplementId,
                            kCategoryIdKey: categoryId,
                            kCheckStatusKey: checkStatus]
                NotificationCenter.default.post(name: YhConstant.YhNotification.clickCertificateFileListItemNotifiction, object: nil, userInfo: dict)
            }
            holdView.addSubview(view)
            
            
            if index == dataModel.supplement_list.count - 1 {
                view.snp.makeConstraints { make in
                    make.top.equalTo(lastView.snp.bottom)
                    make.left.right.equalToSuperview()
                    make.bottom.equalToSuperview()
                }
            } else {
                view.snp.makeConstraints { make in
                    make.top.equalTo(lastView.snp.bottom)
                    make.left.right.equalToSuperview()
                }
            }
            lastView = view
        }
        
        holdView.layer.cornerRadius = kCornerRadius6
        holdView.clipsToBounds = true
        holdView.layer.borderWidth = 1
        holdView.layer.borderColor = UIColor(hex: 0xDEE5F1, alpha: 1.0).cgColor
    }
}
