//
//  YHFileListItemsView2.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFileListItemsView2: UIView {
    override init(frame: CGRect) {
        super.init(frame: frame)
    }
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    var dataModel : YHFileListModel? {
        didSet {
            updateUI()
        }
    }
    
    
    private lazy var topBkg : UIView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "file_list_session_bkg")
        imagV.contentMode = .scaleAspectFill
        return imagV
    }()
    
    
    
    private lazy var titleLable : UILabel = {
        let lable0 = UILabel(text: "title")
        lable0.textColor = UIColor.mainTextColor
        lable0.font = UIFont.PFSC_R(ofSize: 18)
        lable0.textAlignment = .center
        return lable0
    }()
    
    
    
    
    
}

private extension YHFileListItemsView2 {
    func updateUI() {
        removeSubviews()
        guard let dataModel = dataModel else { return }
        addSubview(topBkg)
        topBkg.snp.makeConstraints { make in
            make.top.equalTo(22)
            make.centerX.equalToSuperview()
            make.width.equalTo(146)
            make.height.equalTo(28)
        }
        
        titleLable.text = dataModel.ApplicantName.defaultStringIfEmpty(detaultValue: "--")
        addSubview(titleLable)
        titleLable.snp.makeConstraints { make in
            make.top.equalTo(22)
            make.centerX.equalToSuperview()
            make.left.right.equalToSuperview()
            make.height.equalTo(28)
        }
        
        var lastView : UIView = topBkg
        for (index,item) in dataModel.arrTxt.enumerated() {
            let view = UILabel()
            view.text = item
            view.textColor = UIColor(hex: 0x333333, alpha: 1.0)
            view.numberOfLines = 0
            view.lineBreakMode = .byWordWrapping
            view.font = UIFont.PFSC_R(ofSize: 12)
            addSubview(view)
            
            if index == dataModel.arrTxt.count - 1 {
                view.snp.makeConstraints { make in
                    make.top.equalTo(lastView.snp.bottom).offset(kMargin)
                    make.left.equalTo(kMargin)
                    make.right.equalToSuperview().offset(-kMargin)
                    make.bottom.equalToSuperview()
                }
            } else {
                
                var offset = kMargin
                if index == 0 {
                    offset = 20
                }
                
                view.snp.makeConstraints { make in
                    make.top.equalTo(lastView.snp.bottom).offset(offset)
                    make.left.equalTo(kMargin)
                    make.right.equalToSuperview().offset(-kMargin)
                }
            }
            lastView = view
        }
    }
}

