//
//  YHMyFileListFooterView.swift
//  galaxy
//
//  Created by edy on 2024/7/4.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMyFileListFooterView: UIView {

    lazy var whiteContentView:UIView = {
        let view = UIView()
        view.backgroundColor = .white
        return view
    }()
    
    lazy var titleLabel:UILabel = {
        let label1 = UILabel()
        label1.textColor = UIColor.mainTextColor
        label1.font = UIFont.PFSC_M(ofSize: 18)
        label1.textAlignment = .center
        label1.text = "温馨提示"
        return label1
    }()
    
    lazy var titleBgImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "my_filelist_title_bg"))
        return view
    }()
    
    lazy var tips1Label:UILabel = {
        let label1 = UILabel()
        label1.textColor = UIColor.mainTextColor70
        label1.font = UIFont.PFSC_R(ofSize: 12)
        label1.textAlignment = .left
        label1.text = "1.以上资料请提供清晰完整的彩色扫描件。"
        label1.numberOfLines = 0
        return label1
    }()
    
    lazy var tips2Label:UILabel = {
        let label1 = UILabel()
        label1.textColor = UIColor.mainTextColor70
        label1.font = UIFont.PFSC_R(ofSize: 12)
        label1.textAlignment = .left
        label1.text = "2.照片最好同时提供电子档及时通知我们以避免对申请结果产生影响。"
        label1.numberOfLines = 0
        return label1
    }()
    
    lazy var tips3Label:UILabel = {
        let label1 = UILabel()
        label1.textColor = UIColor.mainTextColor70
        label1.font = UIFont.PFSC_R(ofSize: 12)
        label1.textAlignment = .left
        label1.text = "3.申请递交之后，如目前所报备的情况有任何变化（包含婚姻状况、新生子女、工作情况、亲属关系变化等），请及时总之我们以避免对申请结果产生影响。"
        label1.numberOfLines = 0
        return label1
    }()
    
    lazy var bottomRoundView:UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = 6.0
        view.clipsToBounds = true
        return view
    }()
    
    lazy var thanksLabel:UILabel = {
        let label1 = UILabel()
        label1.textColor = UIColor.init(hex: 0x94A3B8)
        label1.font = UIFont.PFSC_R(ofSize: 12)
        label1.textAlignment = .left
        label1.text = "*感谢您对银河集团的信赖，以上信息均用于香港优才签证申请银河集团承诺对您所提供的信息将绝对保密"
        label1.numberOfLines = 0
        return label1
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupUI() {
        
        self.addSubview(self.whiteContentView)
        self.whiteContentView.addSubview(self.bottomRoundView)
        self.whiteContentView.addSubview(self.titleBgImgView)
        self.whiteContentView.addSubview(self.titleLabel)
        self.whiteContentView.addSubview(self.tips1Label)
        self.whiteContentView.addSubview(self.tips2Label)
        self.whiteContentView.addSubview(self.tips3Label)
        self.addSubview(self.thanksLabel)

        self.whiteContentView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.left.equalTo(16)
            make.right.equalTo(-16)
        }
        
        self.titleLabel.snp.makeConstraints { make in
            make.top.equalTo(24)
            make.centerX.equalToSuperview()
            make.height.equalTo(25)
        }
        
        self.titleBgImgView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.bottom.equalTo(self.titleLabel)
            make.width.equalTo(91)
            make.height.equalTo(9)
        }
        
        self.tips1Label.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(25)
            make.left.equalTo(16)
            make.right.equalTo(-16)
        }
        
        self.tips2Label.snp.makeConstraints { make in
            make.top.equalTo(tips1Label.snp.bottom).offset(16)
            make.left.equalTo(16)
            make.right.equalTo(-16)
        }
        
        self.tips3Label.snp.makeConstraints { make in
            make.top.equalTo(tips2Label.snp.bottom).offset(16)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalToSuperview()
        }
        
        self.bottomRoundView.snp.makeConstraints { make in
            make.left.right.equalTo(self.whiteContentView)
            make.top.equalTo(self.whiteContentView.snp.bottom).offset(-6)
            make.height.equalTo(30)
        }
        
        self.thanksLabel.snp.makeConstraints { make in
            make.top.equalTo(self.bottomRoundView.snp.bottom).offset(24)
            make.left.equalTo(32)
            make.right.equalTo(-32)
            make.bottom.equalTo(-24)
        }
    }
}
