//
//  YHMyFileMethodTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/3/13.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHMyFileMethodType: Int {
    case sign = 0 // 签署
    case downLoad = 1 // 下载
    case look = 2 // 查看
    case edit = 3 // 编辑
    case submit = 4 // 提交
    case upload = 5 // 上传
    case delete = 6 // 删除
    case reUpload = 7 // 重传
}

class YHSignatureToActionTableViewCell: UITableViewCell {
    typealias Block = (YHMyFileMethodType) -> ()
    var block: Block?
    var centerView: UIView!
    var titleLabel: UILabel!
    var topLineView: UIView!
    var bottomView: UIView!
    var bottomLeftLineView: UIView!
    var bottomRightLineView: UIView!
    var fileImageView: UIImageView!
    var fileNameLabel: UILabel!
    var shareButton: UIButton!
    var editButton: UIButton!
    var submitButton: UIButton!
    var lookButton: UIButton!
    var nimiPath: String = ""

    var dataSource: YHMySignatureDetailModel? {
        didSet {
            updateAllViews()
        }
    }

    var isSign: Bool = false {
        didSet {
            updataButton()
        }
    }
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        let width = (KScreenWidth - 32)/3.0
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(8)
            make.bottom.equalTo(-8)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.text = "电子签"
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(24)
        }
        
        topLineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(topLineView)
        topLineView.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.left.equalTo(18)
            make.height.equalTo(1)
            make.top.equalTo(52)
        }
        
        shareButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "share_mini_program"), for: .normal)
            button.addTarget(self, action: #selector(shareButtonClick), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        centerView.addSubview(shareButton)
        shareButton.snp.makeConstraints { make in
            make.top.equalTo(18)
            make.right.equalTo(-24)
            make.height.equalTo(20)
            make.width.equalTo(80)
        }
        
        bottomView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.right.left.equalToSuperview()
            make.height.equalTo(1)
            make.top.equalTo(115)
        }
        
        editButton = {
            let button = UIButton(type: .custom)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
            button.setTitle("签署", for: .normal)
            button.addTarget(self, action: #selector(editButtonClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(editButton)
        editButton.snp.makeConstraints { make in
            make.left.bottom.equalToSuperview()
            make.top.equalTo(bottomView.snp.bottom)
            make.width.equalTo(width)
        }
        
        submitButton = {
            let button = UIButton(type: .custom)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
            button.setTitle("查看", for: .normal)
            button.addTarget(self, action: #selector(submitButtonClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(submitButton)
        submitButton.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.top.equalTo(bottomView.snp.bottom)
            make.left.equalTo(width)
            make.width.equalTo(width)
        }
        
        lookButton = {
            let button = UIButton(type: .custom)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
            button.setTitle("下载", for: .normal)
            button.addTarget(self, action: #selector(lookButtonClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(lookButton)
        lookButton.snp.makeConstraints { make in
            make.right.bottom.equalToSuperview()
            make.top.equalTo(bottomView.snp.bottom)
            make.width.equalTo(width)
        }
        
        fileImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "")
            return view
        }()
        centerView.addSubview(fileImageView)
        fileImageView.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.centerY.equalToSuperview()
            make.width.height.equalTo(31)
        }
        
        fileNameLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            label.numberOfLines = 0
            label.text = "雇主的推荐信(仅签字)华为科技有限公司.doc"
            return label
        }()
        centerView.addSubview(fileNameLabel)
        fileNameLabel.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.left.equalTo(67)
            make.height.equalTo(40)
            make.centerY.equalToSuperview()
        }
        
        bottomLeftLineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(bottomLeftLineView)
        bottomLeftLineView.snp.makeConstraints { make in
            make.left.equalTo(width)
            make.width.equalTo(1)
            make.centerY.equalTo(editButton.snp.centerY)
            make.height.equalTo(16)
        }
        
        bottomRightLineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(bottomRightLineView)
        bottomRightLineView.snp.makeConstraints { make in
            make.left.equalTo(width * 2)
            make.width.equalTo(1)
            make.centerY.equalTo(editButton.snp.centerY)
            make.height.equalTo(16)
        }
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        let suffix = dataSource.doc_send.pathExtension.lowercased()
        var iconImgName = "my_cer_type_pdf"
        if suffix == "jpeg" {
            iconImgName = "my_cer_type_jpg"
        } else if suffix == "jpg" {
            iconImgName = "my_cer_type_jpg"
        } else if suffix == "png" {
            iconImgName = "my_cer_type_png"
        } else if suffix == "pdf" {
            iconImgName = "my_cer_type_pdf"
        } else if suffix == "doc" || suffix == "docx" {
            iconImgName = "my_cer_type_word"
        } else if suffix == "ppt" || suffix == "pptx" {
            iconImgName = "my_cer_type_ppt"
        } else if suffix == "bmp" {
            iconImgName = "my_cer_type_bmp"
        } else if suffix == "tiff" {
            iconImgName = "my_cer_type_tiff"
        }
        fileImageView.image = UIImage(named: iconImgName)
        fileNameLabel.text = dataSource.doc_type_name
        if dataSource.doc_type == 7 || dataSource.doc_type == 8 {
//            shareButton.isHidden = false
        }
    }

    @objc func editButtonClick() {
        if let block = block {
            block(.sign)
        }
    }
    
    @objc func lookButtonClick() {
        if let block = block {
            block(.downLoad)
        }
    }
    
    @objc func submitButtonClick() {
        if let block = block {
            block(.look)
        }
    }
    
    @objc func shareButtonClick() {
        YHShareManager.shared.sendMiniProgram(path: nimiPath, name: dataSource?.doc_type_name ?? "")
    }
    
    func updataButton() {
        if isSign {
            bottomLeftLineView.isHidden = true
            editButton.isHidden = true
            bottomRightLineView.snp.remakeConstraints { make in
                make.centerX.equalToSuperview()
                make.width.equalTo(1)
                make.bottom.equalTo(-17.5)
                make.height.equalTo(16)
            }
            
            submitButton.snp.remakeConstraints { make in
                make.bottom.equalToSuperview()
                make.top.equalTo(bottomView.snp.bottom)
                make.left.equalToSuperview()
                make.right.equalTo(bottomRightLineView.snp.left)
            }
            
            lookButton.snp.remakeConstraints { make in
                make.bottom.equalToSuperview()
                make.top.equalTo(bottomView.snp.bottom)
                make.right.equalToSuperview()
                make.left.equalTo(bottomRightLineView.snp.left)
            }
        }
    }
}
