//
//  YHPreviewInfoCertificateInformationItemsView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
/*
 *证件信息 类型 view
 */

class YHPreviewInfoCertificateInformationItemsView: UIView {
    var dataModel : YHPreviewInfoSessionModel? {
        didSet {
            updateUI()
        }
    }
}

extension YHPreviewInfoCertificateInformationItemsView {
    func updateUI() {
        guard let model = dataModel else { return }
        guard let arrData = model.cellData1,arrData.count > 0 else { return }
        
        
        let sessionView = YHPreviewInfoSingleLineTitleView()
        sessionView.updateTitle(title: model.cellTitle)
        addSubview(sessionView)
        sessionView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.right.equalToSuperview().offset(-18)
            make.left.equalToSuperview().offset(18)
            make.height.equalTo(YHPreviewInfoSingleLineTitleView.viewH)
        }
        
        var tmp : UIView = sessionView
        for (index0,item0) in arrData.enumerated() {
            let lable = UILabel()
            lable.text = item0.cellTitle
            lable.textColor = UIColor.mainTextColor
            lable.font = UIFont.PFSC_M(ofSize: 14)
            addSubview(lable)
            lable.snp.makeConstraints { make in
                make.top.equalTo(tmp.snp.bottom).offset(18)
                make.left.equalTo(18)
                make.right.equalTo(-18)
                make.height.equalTo(17)
            }
            
            tmp = lable
            
            
            let arrData0 = item0.cellData
            if arrData0.count > 0 {
                for(index,item) in arrData0.enumerated() {
                    let cellView = YHPreviewInfoNameAndSubNameItemView()
                    cellView.update(title: item.question, subtitle: item.answer)
                    addSubview(cellView)
                    
                    if index == 0 {
                        //第一个
                        cellView.snp.makeConstraints { make in
                            make.top.equalTo(tmp.snp.bottom).offset(10)
                            make.right.equalToSuperview().offset(-18)
                            make.left.equalToSuperview().offset(18)
                        }
                        
                    } else if index == arrData0.count - 1 {
                        //最后一个
                        
                        if index0 == arrData.count - 1 {
                            //最后一个cell
                            cellView.snp.makeConstraints { make in
                                make.top.equalTo(tmp.snp.bottom)
                                make.right.equalToSuperview().offset(-18)
                                make.left.equalToSuperview().offset(18)
                                make.bottom.equalToSuperview().offset(-21)
                            }
                        } else {
                            cellView.snp.makeConstraints { make in
                                make.top.equalTo(tmp.snp.bottom)
                                make.right.equalToSuperview().offset(-18)
                                make.left.equalToSuperview().offset(18)
                            }
                            
                            
                            let bottomLine = UIView()
                            bottomLine.backgroundColor = UIColor.separatorColor
                            addSubview(bottomLine)
                            bottomLine.snp.makeConstraints { make in
                                make.top.equalTo(cellView.snp.bottom).offset(28)
                                make.right.equalToSuperview().offset(-18)
                                make.left.equalToSuperview().offset(18)
                                make.height.equalTo(0.5)
                            }
                            
                            tmp = bottomLine
                            continue
                        }
                        
                    } else {
                        //中间
                        cellView.snp.makeConstraints { make in
                            make.top.equalTo(tmp.snp.bottom)
                            make.right.equalToSuperview().offset(-18)
                            make.left.equalToSuperview().offset(18)
                        }
                    }
                    tmp = cellView
                }
            }
        } 
        
    }
}
