//
//  YHPreviewInfoNameAndSubNameItemsView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
class YHPreviewInfoNameAndSubNameItemsView: UIView {
    var dataModel : YHPreviewInfoSessionModel? {
        didSet {
            updateUI()
        }
    }
}

extension YHPreviewInfoNameAndSubNameItemsView {
    func updateUI() {
        guard let model = dataModel else { return }
        
        guard let arrData = model.cellData0,arrData.count > 0 else { return }
        
        var lastTagView : UIView?
        if model.cellTitle.isEmpty == false {
            let sessionView = YHPreviewInfoSingleLineTitleView()
            sessionView.updateTitle(title: model.cellTitle)
            addSubview(sessionView)
            sessionView.snp.makeConstraints { make in
                make.top.equalToSuperview()
                make.right.equalToSuperview().offset(-18)
                make.left.equalToSuperview().offset(18)
                make.height.equalTo(YHPreviewInfoSingleLineTitleView.viewH)
            }
            lastTagView = sessionView
        }
        
        
        if arrData.count == 1 {
            let item = arrData[0]
            let cellView = YHPreviewInfoNameAndSubNameItemView()
            cellView.update(title: item.question, subtitle: item.answer)
            addSubview(cellView)
            
            if lastTagView == nil {
                cellView.snp.makeConstraints { make in
                    make.top.equalToSuperview()
                    make.right.equalToSuperview().offset(-18)
                    make.left.equalToSuperview().offset(18)
                    make.bottom.equalToSuperview().offset(-21)
                }
                
            } else {
                cellView.snp.makeConstraints { make in
                    make.top.equalTo(lastTagView!.snp.bottom)
                    make.right.equalToSuperview().offset(-18)
                    make.left.equalToSuperview().offset(18)
                    make.bottom.equalToSuperview().offset(-21)
                }
            }
           
        } else {
            var tmp : UIView? = lastTagView
            for(index,item) in arrData.enumerated() {
                let cellView = YHPreviewInfoNameAndSubNameItemView()
                cellView.update(title: item.question, subtitle: item.answer)
                addSubview(cellView)
                
                if index == arrData.count - 1 {
                    cellView.snp.makeConstraints { make in
                        if tmp == nil {
                            make.top.equalToSuperview()
                            make.right.equalToSuperview().offset(-18)
                            make.left.equalToSuperview().offset(18)
                            make.bottom.equalToSuperview().offset(-21)
                        } else {
                            make.top.equalTo(tmp!.snp.bottom)
                            make.right.equalToSuperview().offset(-18)
                            make.left.equalToSuperview().offset(18)
                            make.bottom.equalToSuperview().offset(-21)
                        }
                    }
                    
                } else {
                    cellView.snp.makeConstraints { make in
                        if tmp == nil {
                            make.top.equalToSuperview()
                            make.right.equalToSuperview().offset(-18)
                            make.left.equalToSuperview().offset(18)
                            
                        } else {
                            make.top.equalTo(tmp!.snp.bottom)
                            make.right.equalToSuperview().offset(-18)
                            make.left.equalToSuperview().offset(18)
                        }
                    }
                }
                tmp = cellView
            }
        }
    }
}
