//
//  YHPersonInfoSessionView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/30.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPreviewInfoSingleLineTitleView: UIView {
    static let viewH : CGFloat = 52
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
   
    //title
    private lazy var nameLable : UILabel = {
        let lable0 = UILabel(text: "--")
        lable0.textColor = UIColor.mainTextColor
        lable0.font = UIFont.PFSC_M(ofSize: 17)
        return lable0
    }()
    
    private lazy var bottomLine : UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.separatorColor
        return view
    }()
    
    private func setupUI() {
        addSubview(bottomLine)
        bottomLine.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        addSubview(nameLable)
        nameLable.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalToSuperview()
            make.bottom.equalTo(bottomLine.snp.top)
        }
    }
}

extension YHPreviewInfoSingleLineTitleView {
    func updateTitle(title : String) {
        nameLable.text = title
    }
}
