//
//  YHImageClipperViewController.swift
//  galaxy
//
//  Created by EDY on 2024/3/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

/*
 let clipperVC = YHImageClipperViewController()
 clipperVC.setBaseImg(image, resultImgSize: clippedImgSize!, type: clipperType)
 clipperVC.cancelClippedHandler = {
 
 }
 clipperVC.successClippedHandler = {[weak self]img in
     if self?.clippedImageHandler != nil{
         self?.clippedImageHandler!(img)
     }
 }
 self.pushViewController(clipperVC, animated: true)
 */


import UIKit

class YHImageClipperViewController: YHBaseViewController {
    typealias CancelClippedHandlerBlock = ()->Void
    typealias SuccessClippedHandlerBlock = (_ content: String) -> Void
    //MARK Public
    public var cancelClippedHandler:CancelClippedHandlerBlock?
    public var successClippedHandler:SuccessClippedHandlerBlock?
    
    public func setBaseImg(_ baseImg: UIImage, resultImgSize: CGSize, type: YHClipperType) {
        self.baseImg = baseImg
        self.resultImgSize = resultImgSize
        clipperView = YHClipperView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight - k_Height_safeAreaInsetsBottom() - 54))
        clipperView?.resultImgSize = resultImgSize
        clipperView?.baseImg = baseImg
        clipperView?.type = type
        self.view.addSubview(clipperView!)
        self.view.sendSubviewToBack(clipperView!)
    }

    private var baseImg: UIImage!
    private var resultImgSize: CGSize!
    //MARK Private
    private var clipperView: YHClipperView?
    private var cannalButton: YHClipperButton!
    private var backImageButton: YHClipperButton!
    private var sureButton: UIButton!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        view.backgroundColor = .black
        // Do any additional setup after loading the view.
        
        setView()
        gk_navigationBar.isHidden = true
    }
    
    func setView() {
        let bottomView = {
            let bottom = UIView()
            bottom.backgroundColor = .black
            return bottom
        }()
        view.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(k_Height_safeAreaInsetsBottom() + 64)
        }
        
        sureButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.backgroundColor = UIColor.brandMainColor
            button.contentHorizontalAlignment = .center
            button.setTitle("确认", for: .normal)
            button.setTitleColor( UIColor(hex:0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(sureBtnClick), for: .touchUpInside)
            return button
        }()
        view.addSubview(sureButton)
        sureButton.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.bottom.equalTo(-10 - k_Height_safeAreaInsetsBottom())
            make.height.equalTo(44)
            make.width.equalTo(93)
        }
        
        cannalButton = {
            let button = YHClipperButton()
            button.setContent("image_clipper_cannal", "取消")
            button.addTarget(self, action: #selector(cannalBtnClick), for: .touchUpInside)
            return button
        }()
        view.addSubview(cannalButton)
        cannalButton.snp.makeConstraints { make in
            make.centerY.equalTo(sureButton.snp.centerY)
            make.left.equalTo(30)
            make.height.equalTo(44)
            make.width.equalTo(30)
        }
        
        backImageButton = {
            let button = YHClipperButton()
            button.setContent("image_clipper_back", "复原")
            button.addTarget(self, action: #selector(backImageBtnClick), for: .touchUpInside)
            return button
        }()
        view.addSubview(backImageButton)
        backImageButton.snp.makeConstraints { make in
            make.centerY.equalTo(sureButton.snp.centerY)
            make.left.equalTo(80)
            make.height.equalTo(44)
            make.width.equalTo(30)
        }
        
    }
    
    @objc private func cannalBtnClick() {
        if cancelClippedHandler != nil {
            cancelClippedHandler!()
        }
        self.navigationController?.popViewController()
    }
    
    @objc private func backImageBtnClick() {
        clipperView?.resultImgSize = resultImgSize
        clipperView?.baseImg = baseImg
//        if cancelClippedHandler != nil {
//            cancelClippedHandler!()
//        }
    }
    
    @objc private func sureBtnClick() {
        let clippedImg = self.clipperView?.clipImg()
        let vc = YHImageResultViewController()
        vc.img = clippedImg
        vc.successHandlerBlock = { [weak self] result in
            guard let self = self else { return }
            if successClippedHandler != nil {
                successClippedHandler!(result)
            }
        }
        self.navigationController?.pushViewController(vc)

    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        navigationController?.isNavigationBarHidden = false
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }

}
