//
//  YHJob responsibilities YHWorkResponsibilitiesTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkResponsibilitiesTableViewCell: UITableViewCell {
    typealias ExampleBlock = () -> ()
    typealias MessageBlock = (_ message: String) -> ()
    var photoBlock: ExampleBlock?
    var exampleBlock: ExampleBlock?
    var messageBlock: MessageBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var subTitleLabel: UILabel!
    var lineView: UIView!
    var messageTextField: UITextView!
    var promptsLabel: UILabel!
    var bottomView: YHWorkActionView!
    var dataSource: String?{
        didSet {
            updateAllViews()
        }
    }
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(7)
        }
        
        titleLabel = {
            let label = UILabel()
            let str = "*" + "工作职责"
            let attributes: [NSAttributedString.Key: Any] = [
                .font: UIFont.PFSC_R(ofSize: 17),
                .foregroundColor: UIColor.mainTextColor
            ]
            let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
            let starRange = NSRange(location: 0, length: 1)
            questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
            label.attributedText = questionAttrStr
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(24)
            make.right.equalTo(-18)
        }
        
        subTitleLabel = {
            let label = UILabel()
            label.text = "温馨提示：如下模板仅供思路参考，工作内容请按您的实际填写，后期文案会基于该内容进行文书材料撰写，望悉知"
            label.textColor = UIColor.brandMainColor
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.numberOfLines = 0
            return label
        }()
        centerView.addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(52)
            make.height.equalTo(40)
            make.right.equalTo(-18)
        }
        
        lineView = {
            let line = UIView()
            line.backgroundColor = UIColor.separatorColor
            return line
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(110)
            make.height.equalTo(1)
            make.right.equalTo(-18)
        }
        
        messageTextField = {
            let textField = UITextView()
            textField.font = UIFont.PFSC_R(ofSize: 14)
            textField.delegate = self
            return textField
        }()
        centerView.addSubview(messageTextField)
        messageTextField.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(111)
            make.bottom.equalTo(-44)
        }
    
        promptsLabel = {
            let prompts = UILabel()
            prompts.font = UIFont.PFSC_R(ofSize: 14)
            prompts.textColor = UIColor(hex: 0xc0c0c0)
            prompts.text = "示例：在职期间负责的核心工作职责，建议不要超过3点。如果就职过多个职位，请分段描述：\n\n例子：\n\n模式1、在司担任某某岗位，任职期间，主要负责xxxx工作；在此期间，组建了xxx。实现了xxx；\n\n模式2、在担任xxx岗位期间，主要负责xxxx工作，具体的工作职责包括如下：\n\n2.1）xxxxxxxx；\n2.2）xxxxxxxx；\n2.3）xxxxxxxx；"
            prompts.numberOfLines = 0
            return prompts
        }()
        centerView.addSubview(promptsLabel)
        promptsLabel.snp.makeConstraints { make in
            make.left.equalTo(22)
            make.right.equalTo(-22)
            make.top.equalTo(116)
        }
        
        bottomView = {
            let view = YHWorkActionView()
            view.exampleBlock = {[weak self] in
                guard let self = self else { return }
                if let block = self.exampleBlock {
                    block()
                }
            }
            
            view.photoBlock = {[weak self] in
                guard let self = self else { return }
                if let block = self.photoBlock {
                    block()
                }
            }
            return view
        }()
        centerView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(44)
        }
    }
    
    func updateAllViews() {
        messageTextField.text = dataSource
        if dataSource?.count != 0 {
            promptsLabel.isHidden = true
        } else {
            promptsLabel.isHidden = false
        }
    }
}

extension YHWorkResponsibilitiesTableViewCell: UITextViewDelegate {
    func textViewDidChange(_ textView: UITextView) {
        if textView.text.count != 0 {
            promptsLabel.isHidden = true
        } else {
            promptsLabel.isHidden = false
        }
        if let block = messageBlock {
            block(textView.text ?? "")
        }
    }
    
    func textView(_ textView: UITextView, shouldChangeTextIn range: NSRange, replacementText text: String) -> Bool {
        let newLength = (textView.text as NSString).length + text.count - range.length
        return newLength <= 2000
    }
}
