//
//  YHPrivacyAlertView.swift
//  galaxy
//
//  Created by EDY on 2024/1/12.
//  Copyright © 2024 www.davidhuang.com. All rights reserved.
//

import UIKit
import AttributedString

class YHPrivacyAlertView: UIView {
    typealias UrlBlock = (_ type : Int,_ url: String) -> ()
    typealias AgreeBlock = () -> ()
    var urlBlock: UrlBlock?
    var agreeBlock: AgreeBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var messageLabel: UILabel!
    var agreeButton: UIButton!
    var disAgressButton: UIButton!
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.width.equalTo(299)
            make.height.equalTo(164)
        }
        
        messageLabel = {
            let label = UILabel()
//            label.textAlignment = .center
            label.numberOfLines = 0
            return label
        }()
        
        let aa: ASAttributedString = .init("请先阅读并同意", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.mainTextColor))
        let cc: ASAttributedString = .init("《隐私协议》", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.brandMainColor), .action {
            if let block = self.urlBlock {
                block(0,YHBaseUrlManager.shared.curPrivacyAgreementUrl())
            }
        })
        let bb: ASAttributedString = .init("和", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.mainTextColor))
        let dd: ASAttributedString = .init("《用户条款》", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.brandMainColor), .action {
            if let block = self.urlBlock {
                block(1,YHBaseUrlManager.shared.curUserItemsUrl())
            }
        })
        messageLabel.attributed.text = aa + cc + bb + dd
        
        
        centerView.addSubview(messageLabel)
        messageLabel.snp.makeConstraints { make in
            make.left.equalTo(22)
            make.right.equalTo(-22)
            make.top.equalTo(40)
        }
        
        disAgressButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor(hex:0xffffff)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("不同意", for: .normal)
            button.setTitleColor( UIColor.brandMainColor, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.layer.borderWidth = 1
            button.layer.borderColor = UIColor.brandMainColor.cgColor
            button.addTarget(self, action: #selector(disagree), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(disAgressButton)
        disAgressButton.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.bottom.equalTo(-21)
            make.width.equalTo(128)
            make.height.equalTo(45)
        }
        
        agreeButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandMainColor
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("同意", for: .normal)
            button.setTitleColor( UIColor(hex:0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(agree), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(agreeButton)
        agreeButton.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.bottom.equalTo(-21)
            make.width.equalTo(128)
            make.height.equalTo(45)
        }
        
    }
    
    @objc func agree() {
        if let block = self.agreeBlock {
            block()
        }
        dismiss()
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        print("处理点击手势")
        dismiss()
    }
    
    @objc func disagree() {
        dismiss()
    }
    
    func dismiss() {
        removeFromSuperview()
    }
}

extension YHPrivacyAlertView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer:UIGestureRecognizer, shouldReceive touch:UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}
