//
//  YHAboutUsViewController.swift
//  galaxy
//
//  Created by edy on 2024/1/6.
//  Copyright © 2024 www.davidhuang.com. All rights reserved.
//

import UIKit
import DeviceKit

struct AboutAdvantageItem {
    var iconName : String
    var title : String
    var detail : String
    var url: String
}

class YHAboutUsViewController: YHBaseViewController {

    lazy var items = {
        return [AboutAdvantageItem(iconName: "about_match", title: "精准匹配".local, detail: "大数据精准匹配，专属方案获批率更高", url: ""),
                AboutAdvantageItem(iconName: "about_response", title: "快速响应", detail: "身份规划师一对一专业服务，第一时间响应您的需求", url: ""),
                AboutAdvantageItem(iconName: "about_service", title: "专业服务", detail: "5年经验+英语专8级文案导师团队倾力支持", url: ""),
                AboutAdvantageItem(iconName: "about_service2", title: "获批保障", detail: "香港专才、香港留学获批常年保持90%以上", url: "")]
    }()
    
    lazy var collectView = {
       
        // 设置布局方向
        let flowLayout = UICollectionViewFlowLayout()
        let margin = 18.0
        let gap = 12.0
        let itemWidth = floor((KScreenWidth-2*margin-gap)/2.0)
        flowLayout.itemSize = CGSize(width: itemWidth, height: itemWidth)
        flowLayout.minimumInteritemSpacing = 12.0
        flowLayout.minimumLineSpacing = 12.0
        flowLayout.scrollDirection = .vertical
        
        let collectinoView = UICollectionView(frame: .zero, collectionViewLayout: flowLayout)
        collectinoView.contentInset = UIEdgeInsets(top: 0, left: margin, bottom: 0, right: margin)
        collectinoView.backgroundColor = UIColor.white
        collectinoView.register(YHAboutUsAdvantageCell.self, forCellWithReuseIdentifier:YHAboutUsAdvantageCell.cellReuseIdentifier)
        collectinoView.delegate = self
        collectinoView.dataSource = self
        collectinoView.backgroundColor = .clear 
        return collectinoView
    }()
    
    lazy var aboutLabel = {
            var label = UILabel()
            label.text = "关于银河".local
            label.textColor = UIColor.mainTextColor
            label.textAlignment = NSTextAlignment.left
            label.font = UIFont.PFSC_B(ofSize: 21)
            return label
    }()
    
    lazy var detailLabel = {
            var label = UILabel()
            label.text = "银河集团专注海外服务17年，总部设立在深圳，现已分别在北京、上海、广州等地建立分公司，立足于香港身份规划服务，业务逐步多元化发展。"
            label.numberOfLines = 0
            label.textColor = .labelTextColor2
            label.textAlignment = NSTextAlignment.left
            label.font = UIFont.PFSC_R(ofSize: 14)
           return label
    }()
    
    lazy var advantageLabel = {
        var label = UILabel()
        label.text = "四大优势"
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .center
        label.font = UIFont.PFSC_B(ofSize: 17)
        return label
    }()
    
    lazy var advantageLeftImgView = {
            let arrowImgView = UIImageView(image: UIImage(named: "about_advantage_left"))
            return arrowImgView
    }()
    
    lazy var advantageRightImgView = {
            let arrowImgView = UIImageView(image: UIImage(named: "about_advantage_right"))
            return arrowImgView
    }()
    
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
        
        self.collectView.reloadData()
        self.collectView.layoutIfNeeded()
    }
    
    func setupUI() {
        
        
        self.gk_navTitle = "关于我们"
        view.backgroundColor = .white
        
        view.addSubview(collectView)
        view.addSubview(aboutLabel)
        view.addSubview(detailLabel)
        view.addSubview(advantageLabel)
        view.addSubview(advantageLeftImgView)
        view.addSubview(advantageRightImgView)

        aboutLabel.snp.makeConstraints { make in
            make.left.equalTo(view).offset(18)
            make.right.equalTo(view).offset(-18)
            make.top.equalTo(view).offset(k_Height_NavigationtBarAndStatuBar+16)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.left.equalTo(view).offset(18)
            make.right.equalTo(view).offset(-18)
            make.top.equalTo(aboutLabel.snp.bottom).offset(12)
        }
        
        advantageLabel.snp.makeConstraints { make in
            make.centerX.equalTo(view)
            make.height.equalTo(40)
            make.top.equalTo(detailLabel.snp.bottom).offset(38)
        }
        
        advantageLeftImgView.snp.makeConstraints { make in
            make.size.equalTo(CGSize(width: 30, height: 3))
            make.centerY.equalTo(advantageLabel)
            make.right.equalTo(advantageLabel.snp.left).offset(-12)
        }
        
        advantageRightImgView.snp.makeConstraints { make in
            make.size.equalTo(CGSize(width: 30, height: 3))
            make.centerY.equalTo(advantageLabel)
            make.left.equalTo(advantageLabel.snp.right).offset(12)
        }
        
        collectView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.top.equalTo(advantageLabel.snp.bottom).offset(18)
        }

    }
}

extension YHAboutUsViewController: UICollectionViewDelegateFlowLayout, UICollectionViewDelegate, UICollectionViewDataSource {
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return items.count
    }
        
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: YHAboutUsAdvantageCell.cellReuseIdentifier, for: indexPath) as! YHAboutUsAdvantageCell
        cell.advantateItem = items[indexPath.row]
        return cell

    }
        
    private func collectionView(collectionView: UICollectionView, didSelectItemAtIndexPath indexPath: NSIndexPath) {
        print("index is \(indexPath.row)")
    }
}
