//
//  YHMyLikeActivityViewController.swift
//  galaxy
//
//  Created by EDY on 2024/7/4.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import JXSegmentedView

class YHMyLikeActivityViewController: YHBaseViewController {
    let homeViewModel: YHHomePageViewModel = YHHomePageViewModel()
    
    var myDefaultNavItemIndex : Int = 0 {
        didSet {
            self.segmentedView.selectItemAt(index: self.myDefaultNavItemIndex)
        }
    }

    var arrItemTitles: [String] = ["我的点赞", "我的收藏", "最近浏览"]
    var arrItemVCs : [YHMyLikeViewController] = []
    var segmentedView : JXSegmentedView = JXSegmentedView(frame: CGRect(x: 0, y: k_Height_NavigationtBarAndStatuBar, width: KScreenWidth, height: 48))
    lazy var segmentedDataSource: JXSegmentedTitleDataSource = {
        let dataSource = JXSegmentedTitleDataSource()
        dataSource.titles = arrItemTitles
        
        dataSource.titleNormalFont = UIFont.PFSC_M(ofSize: 14)
        dataSource.titleNormalColor = .labelTextColor2
        
        dataSource.titleSelectedFont = UIFont.PFSC_M(ofSize: 14)
        dataSource.titleSelectedColor = .mainTextColor
        dataSource.isItemSpacingAverageEnabled = true
        dataSource.itemWidth = JXSegmentedViewAutomaticDimension
        return dataSource
    }()
    
    
    //分类title 所对应的VC
    lazy var listContainerView: JXSegmentedListContainerView! = {
        return JXSegmentedListContainerView(dataSource: self, type: .collectionView)
    }()

    override func viewDidLoad() {
        super.viewDidLoad()
        for i in 0..<arrItemTitles.count {
            if i == 0 {
                let vc = YHMyLikeViewController()
                vc.id = 1
                arrItemVCs.append(vc)
            } else if i == 1{
                let vc = YHMyLikeViewController()
                vc.id = 2
                arrItemVCs.append(vc)
            } else {
                let vc = YHMyLikeViewController()
                vc.id = 3
                arrItemVCs.append(vc)
            }
        }
        //segmentedViewDataSource一定要通过属性强持有！！！！！！！！！
        segmentedView.dataSource = segmentedDataSource
        segmentedView.delegate = self
        view.addSubview(segmentedView)

        segmentedView.listContainer = listContainerView
        view.addSubview(listContainerView)
        
        
        //分类Title
        segmentedView.dataSource = segmentedDataSource
        segmentedView.delegate = self
        
        //配置指示器
        let indicator = JXSegmentedIndicatorLineView()
        indicator.indicatorWidth = 16
        indicator.indicatorColor = UIColor.brandMainColor
        indicator.indicatorCornerRadius = 0
        segmentedView.indicators = [indicator]
        segmentedView.defaultSelectedIndex = self.myDefaultNavItemIndex
        
        getData()
    }

    func getData() {
        gk_navTitle = "我的足迹"
        gk_navBackgroundColor = .white
        gk_navBarAlpha = 1.0
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)

        //处于第一个item的时候，才允许屏幕边缘手势返回
        navigationController?.interactivePopGestureRecognizer?.isEnabled = (segmentedView.selectedIndex == 0)
    }

    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)

        //离开页面的时候，需要恢复屏幕边缘手势，不能影响其他页面
        navigationController?.interactivePopGestureRecognizer?.isEnabled = true
    }
    
    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()
        segmentedView.frame = CGRect(x: 0, y: k_Height_NavigationtBarAndStatuBar, width: view.bounds.size.width, height: 48)
        listContainerView.frame = CGRect(x: 0, y: k_Height_NavigationtBarAndStatuBar + 48, width: view.bounds.size.width, height: view.bounds.size.height - 48 - k_Height_NavigationtBarAndStatuBar)
        
        segmentedView.backgroundColor = .white
    }
}

extension YHMyLikeActivityViewController: JXSegmentedViewDelegate {
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {
        
    }
    
    func segmentedView(_ segmentedView: JXSegmentedView, scrollingFrom leftIndex: Int, to rightIndex: Int, percent: CGFloat) {
    }
}

extension YHMyLikeActivityViewController: JXSegmentedListContainerViewDataSource {
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        if let titleDataSource = segmentedView.dataSource as? JXSegmentedBaseDataSource {
            return titleDataSource.dataSource.count
        }
        return 0
    }

    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        return arrItemVCs[index] as JXSegmentedListContainerViewListDelegate
    }
}
