//
//  YHMyPermissionCell.swift
//  galaxy
//
//  Created by edy on 2024/4/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMyPermissionCell: UITableViewCell {

   
    static let cellReuseIdentifier = "YHMyPermissionCell"
    static let enableColor = UIColor.mainTextColor30
    static let disableColor = UIColor.mainTextColor70

    var titleLabel: UILabel!
    var statusLabel: UILabel!
    var rightArrowImgV: UIImageView!
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        
        titleLabel = UILabel()
        titleLabel.textColor = UIColor.mainTextColor
        titleLabel.textAlignment = .left
        titleLabel.font = UIFont.PFSC_R(ofSize: 15)
        contentView.addSubview(titleLabel)

        statusLabel = UILabel()
        statusLabel.textColor = Self.disableColor
        statusLabel.textAlignment = .right
        statusLabel.font = UIFont.PFSC_R(ofSize:15)
        contentView.addSubview(statusLabel)
        
        rightArrowImgV = UIImageView(image: UIImage(named: "service_center_right_next_icon"))
        contentView.addSubview(rightArrowImgV)
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(20)
            make.centerY.equalToSuperview()
            make.right.equalTo(statusLabel.snp.left).offset(-10)
        }
        
        statusLabel.snp.makeConstraints { make in
            make.right.equalTo(rightArrowImgV.snp.left).offset(-4)
            make.size.equalTo(CGSize(width: 46, height: 21))
            make.centerY.equalToSuperview()
        }
        
        rightArrowImgV.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-20)
            make.size.equalTo(CGSize(width: 16, height: 16))
            make.centerY.equalToSuperview()
        }
        
    }
    
    func updateModel(_ model: YHPermissionItem) {
        
        self.titleLabel.text = model.title
        self.statusLabel.text = model.enableStatus ? "已开启".local : "未开启".local
        self.statusLabel.textColor = model.enableStatus ? Self.enableColor : Self.disableColor
    }
}
