//
//  YHAppVersionForceUpdateView.swift
//  galaxy
//
//  Created by edy on 2024/5/7.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//
// 【Usage】
/*
 YHAppVersionForceUpdateView.alertView().show()
 
 */

import UIKit

class YHAppVersionForceUpdateView: UIView {
    
    // 底层蒙版
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = .alertMaskColor
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .center
        label.font = UIFont.PFSC_B(ofSize:17)
        label.text = "版本更新"
        return label
    }()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .center
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize:16)
        label.text = "当前APP版本过低，为保证正常使用，请进行更新"
        return label
    }()
    
    lazy var updateBtn:UIButton = {
        let btn = UIButton()
        btn.setTitle("更新".local, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(.white, for: .normal)
        btn.backgroundColor = UIColor.brandMainColor
        btn.layer.cornerRadius = kCornerRadius3
        btn.addTarget(self, action: #selector(didClickUpdateBtn), for: .touchUpInside)
        return btn
    }()
    
    lazy var exitBtn:UIButton = {
        let btn = UIButton()
        btn.setTitle("退出APP", for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(UIColor.brandMainColor, for: .normal)
        btn.layer.borderWidth = 1.0
        btn.layer.borderColor = UIColor.brandMainColor.cgColor
        btn.backgroundColor = .white
        btn.layer.cornerRadius = kCornerRadius3
        btn.addTarget(self, action: #selector(didClickExitBtn), for: .touchUpInside)
        return btn
    }()
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    static func alertView() -> YHAppVersionForceUpdateView {
        let alertView = YHAppVersionForceUpdateView(frame:UIScreen.main.bounds)
        return alertView
    }
    
    func createUI() {
        self.addSubview(blackMaskView)
        self.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(lineView)
        whiteContentView.addSubview(detailLabel)
        whiteContentView.addSubview(exitBtn)
        whiteContentView.addSubview(updateBtn)
        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(38)
            make.right.equalTo(-38)
            make.centerX.equalToSuperview()
            make.centerY.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(15)
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.height.equalTo(24)
        }
        
        lineView.snp.makeConstraints { make in
            make.left.right.equalTo(0)
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
            make.height.equalTo(0.5)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(lineView.snp.bottom).offset(21)
        }
        
        exitBtn.snp.makeConstraints { make in
            make.top.equalTo(detailLabel.snp.bottom).offset(29)
            make.left.equalTo(16)
            make.right.equalTo(updateBtn.snp.left).offset(-10)
            make.height.equalTo(45)
            make.width.equalTo(updateBtn)
            make.bottom.equalTo(-16)
        }
        
        updateBtn.snp.makeConstraints { make in
            make.top.bottom.height.equalTo(exitBtn)
            make.right.equalTo(-16)
        }
    }
    
    @objc func show() {
        if YHLoginManager.shared.isShowVersionUpdate == false {
            YHLoginManager.shared.isShowVersionUpdate = true
            UIApplication.shared.yhKeyWindow()?.addSubview(self)
        }
    }
    
    @objc func didClickUpdateBtn() {
        YHAppVersionManager.shared.goToAppStore()
    }
    
    @objc func didClickExitBtn() {
        DispatchQueue.main.async {
           exit(0)
        }
    }
}
