//
//  YHFindAppNewVersionView.swift
//  galaxy
//
//  Created by edy on 2024/5/7.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//
//
/*  【Usage】
 let alertView = YHFindAppNewVersionView.alertView(version: "1.0.0").callBack {
     
 } dismissBlock: {
     
 }
 alertView.updateContentArray(["1、阿斯顿发发。 2、阿打发打发是的发生富士达"])
 alertView.show()
 
 */


import UIKit

class YHUpdateContentItemView: UIView {
    lazy var pointView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.brandMainColor
        view.layer.cornerRadius = 2.0
        return view
    }()
    
    lazy var contentLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize:14)
        return label
    }()
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    func createUI() {
        self.addSubview(pointView)
        self.addSubview(contentLabel)
        
        pointView.snp.makeConstraints { make in
            make.width.height.equalTo(4)
            make.left.equalToSuperview()
            make.top.equalTo(8)
        }
        contentLabel.snp.makeConstraints { make in
            make.left.equalTo(pointView.snp.right).offset(10)
            make.top.right.equalToSuperview()
            make.height.greaterThanOrEqualTo(20)
            make.bottom.equalTo(0)
        }
    }
}

class YHFindAppNewVersionView: UIView {
    
    // 底层蒙版
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = .alertMaskColor
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var headImgView: UIImageView = {
        let imgView = UIImageView(image: UIImage(named: "app_version_update_bg"))
        return imgView
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.font = UIFont.PFSC_B(ofSize:20)
        label.text = "发现新版本"
        return label
    }()
    
    lazy var versionLabel: UILabel = {
        let label = UILabel()
        label.text = "V0.0.0"
        label.textColor = UIColor.brandMainColor
        label.textAlignment = .center
        label.font = UIFont.PFSC_R(ofSize:14)
        label.layer.cornerRadius = kCornerRadius3
        label.layer.borderWidth = 0.5
        label.layer.borderColor = UIColor.init(hex: 0x0046B5, alpha: 0.5).cgColor
        return label
    }()
    
    lazy var updateTitleLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.font = UIFont.PFSC_B(ofSize:16)
        label.text = "版本更新内容:"
        return label
    }()
    
    lazy var scrollView: UIScrollView = {
        let view = UIScrollView()
        view.showsVerticalScrollIndicator = false
        view.addSubview(updateContentView)
        return view
    }()
    
    lazy var updateContentView: UIView = {
        let view = UIView()
        return view
    }()
    
    lazy var updateBtn:UIButton = {
        let btn = UIButton()
        btn.setTitle("立即更新".local, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(.white, for: .normal)
        btn.backgroundColor = UIColor.brandMainColor
        btn.layer.cornerRadius = kCornerRadius3
        btn.addTarget(self, action: #selector(didClickUpdateBtn), for: .touchUpInside)
        return btn
    }()
    
    lazy var closeBtn:UIButton = {
        let btn = UIButton()
        btn.setImage(UIImage(named: "update_close"), for: .normal)
        btn.addTarget(self, action: #selector(didCloseBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    static func alertView(version:String?) -> YHFindAppNewVersionView {
        let alertView = YHFindAppNewVersionView(frame:UIScreen.main.bounds)
        if let version = version {
            alertView.versionLabel.text = "V"+version
        }
        return alertView
    }
    
    func updateContentArray(_ arr: [String]) {
        updateContentView.removeSubviews()
        updateContentView.snp.remakeConstraints { make in
            make.edges.equalToSuperview()
            make.width.equalToSuperview()
        }
        var lastItemView:YHUpdateContentItemView? = nil
        for (index, text) in arr.enumerated() {
            let targetView = YHUpdateContentItemView(frame: .zero)
            targetView.contentLabel.text = text
            updateContentView.addSubview(targetView)
            targetView.snp.makeConstraints { make in
                make.left.right.equalToSuperview()
                if let lastItemView = lastItemView {
                    make.top.equalTo(lastItemView.snp.bottom).offset(8)
                } else {
                    make.top.equalToSuperview()
                }
                if index == arr.count-1 {
                    make.bottom.equalToSuperview()
                }
            }
            lastItemView = targetView
        }
        self.setNeedsLayout()
        self.layoutIfNeeded()
    }
    
    func createUI() {
        
        self.addSubview(blackMaskView)
        self.addSubview(whiteContentView)
        self.addSubview(closeBtn)
        
        whiteContentView.addSubview(headImgView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(versionLabel)
        whiteContentView.addSubview(updateTitleLabel)
        whiteContentView.addSubview(scrollView)
        whiteContentView.addSubview(updateBtn)
        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(38)
            make.right.equalTo(-38)
            make.centerX.equalToSuperview()
            make.centerY.equalToSuperview()
        }
        
        headImgView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(headImgView.snp.width).multipliedBy(5.0/12.0)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(28)
            make.right.equalTo(-28)
            make.top.equalTo(23)
            make.height.equalTo(28)
        }
        
        versionLabel.snp.makeConstraints { make in
            make.left.equalTo(titleLabel)
            make.top.equalTo(titleLabel.snp.bottom).offset(6)
            make.width.equalTo(58)
            make.height.equalTo(22)
        }
        
        updateTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(headImgView.snp.bottom).offset(16)
            make.height.equalTo(22)
        }
        
        scrollView.snp.makeConstraints { make in
            make.height.equalTo(128)
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(updateTitleLabel.snp.bottom).offset(8)
            make.bottom.equalTo(updateBtn.snp.top).offset(-16)
        }
        
        updateContentView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
            make.width.equalToSuperview()
        }

        updateBtn.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.height.equalTo(45)
            make.bottom.equalTo(-16)
        }
        
        closeBtn.snp.makeConstraints { make in
            make.width.height.equalTo(24)
            make.top.equalTo(whiteContentView.snp.bottom).offset(20)
            make.centerX.equalTo(whiteContentView)
        }
    }
    
    @objc func show() {
        if YHLoginManager.shared.isShowVersionUpdate == false {
            YHLoginManager.shared.isShowVersionUpdate = true
            UIApplication.shared.yhKeyWindow()?.addSubview(self)
        }
    }
    
    @objc func dismiss() {
        YHLoginManager.shared.isShowVersionUpdate = false
        self.removeFromSuperview()
    }
    
    @objc func didCloseBtnClicked() {
        YHAppVersionManager.shared.saveShowLatestUpdateVersion()
        dismiss()
    }
    
    @objc func didClickUpdateBtn() {
        YHAppVersionManager.shared.saveShowLatestUpdateVersion()
        YHAppVersionManager.shared.goToAppStore()
    }
}
