//
//  YHResourceDetailHeaderCell.swift
//  galaxy
//
//  Created by alexzzw on 2025/9/30.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import Kingfisher

class YHResourceDetailHeaderCell: UITableViewCell {
    
    private lazy var logoImageView: UIImageView = {
        let imageView = UIImageView()
        imageView.contentMode = .scaleAspectFill
        imageView.clipsToBounds = true
        imageView.layer.cornerRadius = 4
        imageView.backgroundColor = .white
        imageView.layer.borderWidth = 1
        imageView.layer.borderColor = UIColor.brandGrayColor3.cgColor
        return imageView
    }()
    
    private lazy var companyNameLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_M(ofSize: 21)
        label.textColor = UIColor.brandGrayColor8
        label.numberOfLines = 2
        return label
    }()
    
    private lazy var companyEnglishNameLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.textColor = UIColor.brandGrayColor6
        label.numberOfLines = 2
        return label
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        selectionStyle = .none
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        
        contentView.addSubview(logoImageView)
        contentView.addSubview(companyNameLabel)
        contentView.addSubview(companyEnglishNameLabel)
        
        logoImageView.snp.makeConstraints { make in
            make.top.left.equalToSuperview().inset(20)
            make.width.height.equalTo(60)
        }
        
        companyNameLabel.snp.makeConstraints { make in
            make.top.equalTo(logoImageView.snp.bottom).offset(12)
            make.right.lessThanOrEqualToSuperview().offset(-20)
            make.left.equalTo(logoImageView)
        }
        
        companyEnglishNameLabel.snp.makeConstraints { make in
            make.left.equalTo(logoImageView)
            make.right.lessThanOrEqualToSuperview().offset(-20)
            make.top.equalTo(companyNameLabel.snp.bottom).offset(4)
            make.bottom.equalToSuperview().offset(-32)
        }
    }
    
    func configure(with model: YHResourceDetailModel) {
        // 设置Logo
        if !model.companyLogoUrl.isEmpty {
            logoImageView.kf.setImage(
                with: URL(string: model.companyLogoUrl),
                placeholder: UIImage(named: "plan_product_default")
            )
        } else {
            logoImageView.image = UIImage(named: "plan_product_default")
        }
        
        // 设置公司名称
        companyNameLabel.text = model.displayName
        
        // 设置英文名称
        if !model.company_english_name.isEmpty {
            companyEnglishNameLabel.text = model.company_english_name
            companyEnglishNameLabel.isHidden = false
        } else {
            companyEnglishNameLabel.isHidden = true
        }
    }
}
