//
//  YHHKRequiredItemListCell.swift
//  galaxy
//
//  Created by Dufet on 2024/11/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKRequiredItemListCell: UITableViewCell {

    static let cellReuseIdentifier = "YHHKRequiredItemListCell"
    
    var passArr: [YHComprehensiveEevaluationModel] = [] {
        didSet {
            listView.removeSubviews()
            listView.addSubview(topView)
            topView.snp.remakeConstraints { make in
                make.left.right.top.equalToSuperview()
                make.height.equalTo(42)
            }
            
            var lastItemView: YHHKRequiredItemView?
            for (index, model) in passArr.enumerated() {
                let itemView = YHHKRequiredItemView(frame: .zero)
                itemView.text = model.standardName
                itemView.backgroundColor = index%2 == 0 ? .white : .init(hex: 0xFBF7F3)
                listView.addSubview(itemView)
                itemView.snp.makeConstraints { make in
                    make.left.right.equalToSuperview()
                    if let lastItemView = lastItemView {
                        make.top.equalTo(lastItemView.snp.bottom)
                        
                    } else {
                        make.top.equalTo(topView.snp.bottom)
                    }
                    if index == passArr.count-1 {
                        make.bottom.equalToSuperview()
                    }
                }
                lastItemView = itemView
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    lazy var topView: UIView = {
        
        let view = UIView()
        view.backgroundColor = .init(hex: 0xFBF7F3)
        
        let requireLabel = UILabel()
        requireLabel.text = "港府要求"
        requireLabel.font = UIFont.PFSC_M(ofSize: 13)
        requireLabel.textColor = UIColor.init(hex: 0xD48638)
        view.addSubview(requireLabel)
        
        let fitLabel = UILabel()
        fitLabel.text = "是否符合"
        fitLabel.font = UIFont.PFSC_M(ofSize: 13)
        fitLabel.textColor = UIColor.init(hex: 0x6D788A)
        view.addSubview(fitLabel)
        
        let line = UIView()
        line.backgroundColor = UIColor.init(hex: 0xF7F2ED)
        view.addSubview(line)

        requireLabel.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(12)
        }
        
        fitLabel.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(-12)
        }
        
        line.snp.makeConstraints { make in
            make.right.equalTo(-72)
            make.top.bottom.equalToSuperview()
            make.width.equalTo(0.5)
        }

        return view
    }()
    
    lazy var whiteBgView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        return view
    }()
    
    lazy var listView: UIView = {
        let view = UIView()
        view.layer.cornerRadius = 4.0
        view.layer.borderWidth = 0.5
        view.layer.borderColor = UIColor.init(hex: 0xF7F2ED).cgColor
        view.clipsToBounds = true
        return view
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        selectionStyle = .none
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        contentView.clipsToBounds = true
        
        self.addSubview(whiteBgView)
        self.addSubview(listView)
        listView.addSubview(topView)
        
        whiteBgView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.top.bottom.equalToSuperview()
        }
        
        listView.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.top.equalToSuperview()
            make.bottom.equalTo(-26)
        }
        
        topView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(42)
        }
    }
}
