//
//  YHServiceOrderInIncubationView.swift
//  galaxy
//
//  Created by EDY on 2024/11/13.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHServiceOrderInIncubationView: UIView {
    typealias Block = () -> Void
    var block: Block?
    var centerView: UIView!
    var centerImageView: UIView!
    var titleLabel: UILabel!
    var closeButton: UIButton!
    var knowButton: UIButton!
    var measageLabel: UILabel!
    var showBack: Bool = true {
        didSet {
            if !showBack {
                closeButton.isHidden = true
                knowButton.setTitle("我知道了", for: .normal)
                knowButton.snp.remakeConstraints { make in
                    make.right.equalTo(-20)
                    make.left.equalTo(20)
                    make.height.equalTo(46)
                    make.bottom.equalTo(-20)
                }
            }
        }
    }
    
    static func show(_ flag: Bool = true, callBack: @escaping (() -> Void)) {
        let view = YHServiceOrderInIncubationView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        view.showBack = flag
        view.block = callBack
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius8
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.center.equalToSuperview()
            make.height.equalTo(361)
            make.width.equalTo(299)
        }
        
        centerImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "service_order_in_incubation_view")
            return view
        }()
        centerView.addSubview(centerImageView)
        centerImageView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.width.height.equalTo(53)
            make.top.equalTo(30)
        }
        
        titleLabel = {
            let label = UILabel()
            label.text = "订单孵化中"
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.textAlignment = .center
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(99)
            make.left.height.equalTo(21)
            make.right.equalTo(-21)
        }
        
        closeButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("返回", for: .normal)
            button.setTitleColor( UIColor.brandMainColor, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.layer.borderWidth = 1
            button.layer.borderColor = UIColor.brandMainColor.cgColor
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(closeButton)
        closeButton.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.width.equalTo(123)
            make.height.equalTo(46)
            make.bottom.equalTo(-20)
        }
        
        knowButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("去更新", for: .normal)
            button.setTitleColor( UIColor(hex: 0xffffff), for: .normal)
            button.backgroundColor = UIColor.brandMainColor
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(goNext), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(knowButton)
        knowButton.snp.makeConstraints { make in
            make.right.equalTo(-20)
            make.width.equalTo(123)
            make.height.equalTo(46)
            make.bottom.equalTo(-20)
        }
        
        measageLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            label.numberOfLines = 0
            return label
        }()
        centerView.addSubview(measageLabel)
        measageLabel.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.left.equalTo(21)
            make.top.equalTo(131)
        }
        
        let a: ASAttributedString = .init("您的高才订单目前处于孵化状态， 若自评已满足申请条件（", .font(UIFont.PFSC_R(ofSize: 15)), .foreground(UIColor(hex: 0x6d788a)))
        
        let aa: ASAttributedString = .init(NSAttributedString(string: "过去12个月收入为250W港币以上或获得入境处认可的院校学士学位"), .font(UIFont.PFSC_M(ofSize: 15)), .foreground(UIColor.brandMainColor))
        
        let aaa: ASAttributedString = .init("），可点击进入【我的信息】，如实更新完善您的信息， 检查无误后提交，文案老师会进行评估并反馈。", .font(UIFont.PFSC_R(ofSize: 15)), .foreground(UIColor(hex: 0x6d788a)))

        measageLabel.attributed.text = a + aa + aaa
       
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        dismiss()
    }
    
    @objc func dismiss() {
        removeFromSuperview()
    }
    
    @objc func goNext() {
        if let block = block {
            block()
        }
        dismiss()
    }
}
