//
//  YHHomeHeadView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/7.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

// 定义类型枚举
enum YHHomeHeadViewStyleType {
    // 新人测评页入口A
    case evaluationA
    // 优才新政交付B--测评
    case evaluationB
    // 优才订单提示视图
    case orderTips
    // 新人测评页入口A和优才新政交付B--测评
    case evaluationAAndB
    // 优才新政交付B--测评和优才订单提示视图
    case evaluationBAndOrderTips
    
    func getHeight(_ orderTipsHeight: CGFloat = 0) -> CGFloat {
        switch self {
        case .evaluationA:
            return 20 + YHEvaluationView.viewH
        case .evaluationB:
            return 20 + YHTalentProgramEvaluationView.viewH
        case .orderTips:
            return 20 + orderTipsHeight
        case .evaluationAAndB:
            return (20 + YHEvaluationView.viewH) + YHTalentProgramEvaluationView.viewH + 20
        case .evaluationBAndOrderTips:
            return 20 + YHTalentProgramEvaluationView.viewH + 20 + orderTipsHeight
        }
    }
}

class YHHomeHeadView: UIView {
    
    private static let  topMargin: CGFloat = 10.0
    var kingModel: [YHHomeFourKingInfoModel] = [] {
        didSet {
            homeKingKongBlock.kingModel = kingModel
        }
    }
    // 不包含订单提示视图的总高度
//    private static let fixViewH : CGFloat = YHHomeHeadView.topMargin + (YHHomeBannerView.viewH) + (20 + YHHomeKingKongBlockView.viewH) + (20 + 1) + (20 + YHAiRadarAreaView.viewH) + (20 + YHHomeSalonAreaView.viewH) + (20 + 1) + 20
    private static let fixViewH: CGFloat = YHHomeHeadView.topMargin + (YHHomeBannerView.viewH) + (20 + YHHomeKingKongBlockView.viewH) + (20 + 1) + 20 + YHCircleEntryView.viewH + 16
    
    var galaxyManagerItemClickEvent: (() -> Void)?
    var orderTipsViewClickEvent: (() -> Void)?
    var circleEntryBlock: (() -> Void)?
    
    func getHomeHeadViewH(headStyle: YHHomeHeadViewStyleType) -> CGFloat {
        return YHHomeHeadView.fixViewH + headStyle.getHeight(orderTipsView.orderTipsViewStyle.getHeight()) + YHHomeHeadView.topMargin
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    // 1.bannner
    lazy var homeBannerView: YHHomeBannerView = {
        let view = YHHomeBannerView()
        return view
    }()
    
    // 3. 四大金刚区
    lazy var homeKingKongBlock: YHHomeKingKongBlockView = {
        let view = YHHomeKingKongBlockView()
        view.kingModel = kingModel
        return view
    }()
    
    lazy var bannerLineTop: UIView = {
        let line = UIView()
        line.backgroundColor = UIColor(hex: 0xF0F3F7, alpha: 1.0)
        return line
    }()
    
    // 4.优才订单提示视图  - 未登录态不展示
    lazy var orderTipsView: YHOrderTipsView = {
        let view = YHOrderTipsView(frame: .zero)
        view.galaxyManagerItemClickEvent = { [weak self] in
            self?.galaxyManagerItemClickEvent?()
        }
        view.buttonClickEvent = { [weak self] in 
            self?.orderTipsViewClickEvent?()
        }
        view.isHidden = true
        return view
    }()
    
    // 4.1 测评页入口A - 未登录时/没有订单时 展示
    lazy var evaluationView: YHEvaluationView = {
        let view = YHEvaluationView(frame: .zero)
        view.isHidden = true
        return view
    }()
    
    // 4.2 优才新政交付B--测评功能（B端）
    lazy var talentEvaluationView: YHTalentProgramEvaluationView = {
        let view = YHTalentProgramEvaluationView(frame: .zero)
        view.isHidden = true
        return view
    }()
    
    // 5. ai人脉雷达
//    lazy var aiRadarArea: YHAiRadarAreaView = {
//        let view = YHAiRadarAreaView(frame: .zero)
//        return view
//    }()
    
//    //6.银河线下沙龙
//    lazy var salonArea: YHHomeSalonAreaView = {
//        let view = YHHomeSalonAreaView(frame: .zero)
//        return view
//    }()
    
    lazy var bannerLineBottom: UIView = {
        let line = UIView()
        line.backgroundColor = UIColor(hex: 0xF0F3F7, alpha: 1.0)
        return line
    }()
    
    lazy var circleEntryView: YHCircleEntryView = {
        let view = YHCircleEntryView()
        view.circleEntryBlock = { [weak self] in
            self?.circleEntryBlock?()
        }
        return view
    }()
    
    // 是否隐藏优才订单提示视图
    var homeHeadViewStyleType: YHHomeHeadViewStyleType = .evaluationA {
        didSet {
            updateSubViewsConstraints()
        }
    }
    
    func updateSubViewsConstraints() {
        homeBannerView.snp.remakeConstraints { make in
            make.top.equalTo(YHHomeHeadView.topMargin)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHHomeBannerView.viewH)
        }
        
        homeKingKongBlock.snp.remakeConstraints { make in
            make.top.equalTo(homeBannerView.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHHomeKingKongBlockView.viewH)
        }
        bannerLineTop.snp.remakeConstraints { make in
            make.top.equalTo(homeKingKongBlock.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(1)
        }
        
//        orderTipsView.snp.removeConstraints()
        var lastView: UIView = evaluationView
        switch homeHeadViewStyleType {
        case .evaluationA:
            orderTipsView.isHidden = true
            evaluationView.isHidden = false
            talentEvaluationView.isHidden = true
            evaluationView.snp.remakeConstraints { make in
                make.top.equalTo(circleEntryView.snp.bottom).offset(20)
                make.left.right.equalToSuperview()
                make.height.equalTo(YHEvaluationView.viewH)
            }
            lastView = evaluationView
        case .evaluationB:
            orderTipsView.isHidden = true
            evaluationView.isHidden = true
            talentEvaluationView.isHidden = false
            talentEvaluationView.snp.remakeConstraints { make in
                make.top.equalTo(circleEntryView.snp.bottom).offset(20)
                make.left.right.equalToSuperview()
                make.height.equalTo(YHEvaluationView.viewH)
            }
            lastView = talentEvaluationView
        case .orderTips:
            orderTipsView.isHidden = false
            evaluationView.isHidden = true
            talentEvaluationView.isHidden = true
            orderTipsView.snp.remakeConstraints { make in
                make.top.equalTo(circleEntryView.snp.bottom).offset(20)
                make.left.right.equalToSuperview()
                make.height.equalTo(orderTipsView.tipViewH)
            }
            lastView = orderTipsView
        case .evaluationAAndB:
            orderTipsView.isHidden = true
            evaluationView.isHidden = false
            talentEvaluationView.isHidden = false
            evaluationView.snp.remakeConstraints { make in
                make.top.equalTo(circleEntryView.snp.bottom).offset(20)
                make.left.right.equalToSuperview()
                make.height.equalTo(YHEvaluationView.viewH)
            }
            talentEvaluationView.snp.remakeConstraints { make in
                make.top.equalTo(evaluationView.snp.bottom).offset(20)
                make.left.right.equalToSuperview()
                make.height.equalTo(YHEvaluationView.viewH)
            }
            lastView = talentEvaluationView
        case .evaluationBAndOrderTips:
            orderTipsView.isHidden = false
            evaluationView.isHidden = true
            talentEvaluationView.isHidden = false
            talentEvaluationView.snp.remakeConstraints { make in
                make.top.equalTo(circleEntryView.snp.bottom).offset(20)
                make.left.right.equalToSuperview()
                make.height.equalTo(YHEvaluationView.viewH)
            }
            orderTipsView.snp.remakeConstraints { make in
                make.top.equalTo(talentEvaluationView.snp.bottom).offset(20)
                make.left.right.equalToSuperview()
                make.height.equalTo(orderTipsView.tipViewH)
            }
            lastView = orderTipsView
        }
//        aiRadarArea.snp.remakeConstraints { make in
//            make.top.equalTo(lastView.snp.bottom).offset(20)
//            make.left.right.equalToSuperview()
//            make.height.equalTo(YHAiRadarAreaView.viewH)
//        }
//        salonArea.snp.remakeConstraints { make in
//            make.top.equalTo(aiRadarArea.snp.bottom).offset(20)
//            make.left.right.equalToSuperview()
//            make.height.equalTo(YHHomeSalonAreaView.viewH)
//        }
//        bannerLineBottom.snp.remakeConstraints { make in
//            make.top.equalTo(salonArea.snp.bottom).offset(20)
//            make.left.right.equalToSuperview()
//            make.height.equalTo(1)
//        }
        bannerLineBottom.snp.remakeConstraints { make in
            make.top.equalTo(lastView.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(1)
        }
    }
}

private extension YHHomeHeadView {
    func initView() {
        backgroundColor = .clear
        
        addSubview(homeBannerView)
        homeBannerView.snp.makeConstraints { make in
            make.top.equalTo(YHHomeHeadView.topMargin)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHHomeBannerView.viewH)
        }
        
        addSubview(homeKingKongBlock)
        homeKingKongBlock.snp.makeConstraints { make in
            make.top.equalTo(homeBannerView.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHHomeKingKongBlockView.viewH)
        }
        
        addSubview(bannerLineTop)
        bannerLineTop.snp.makeConstraints { make in
            make.top.equalTo(homeKingKongBlock.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(1)
        }
        
        addSubview(circleEntryView)
        circleEntryView.snp.makeConstraints { make in
            make.top.equalTo(bannerLineTop.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHCircleEntryView.viewH)
        }
        
        // 订单入口
        addSubview(orderTipsView)
        orderTipsView.snp.makeConstraints { make in
            make.top.equalTo(circleEntryView.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
//            make.height.equalTo(226)
            make.height.equalTo(orderTipsView.tipViewH)
        }
        
        // 测评界面
        addSubview(evaluationView)
        evaluationView.snp.makeConstraints { make in
            make.top.equalTo(circleEntryView.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHEvaluationView.viewH)
        }
        
        addSubview(talentEvaluationView)
        talentEvaluationView.snp.makeConstraints { make in
            make.top.equalTo(evaluationView.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHEvaluationView.viewH)
        }
        
//        addSubview(aiRadarArea)
//        aiRadarArea.snp.makeConstraints { make in
//            make.top.equalTo(bannerLineTop.snp.bottom).offset(20)
//            make.left.right.equalToSuperview()
//            make.height.equalTo(YHAiRadarAreaView.viewH)
//        }
//        
//        addSubview(salonArea)
//        salonArea.snp.makeConstraints { make in
//            make.top.equalTo(aiRadarArea.snp.bottom).offset(20)
//            make.left.right.equalToSuperview()
//            make.height.equalTo(YHHomeSalonAreaView.viewH)
//        }
        
//        addSubview(bannerLineBottom)
//        bannerLineBottom.snp.makeConstraints { make in
//            make.top.equalTo(salonArea.snp.bottom).offset(20)
//            make.left.right.equalToSuperview()
//            make.height.equalTo(1)
//        }
        addSubview(bannerLineBottom)
        bannerLineBottom.snp.makeConstraints { make in
            make.top.equalTo(circleEntryView.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(1)
        }
        
    }
}
