//
//  YHResignDocumentStage.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation

// 1-首次递交；2-补件递交；3-拒签递交
enum YHResignDocumentStage: Int {
    case initialSubmission = 1
    case supplementarySubmission = 2
    case resubmissionAfterRejection = 3
    
    func title() -> String {
        switch self {
        case .initialSubmission:
            return "​续签递交文书"
        case .supplementarySubmission:
            return "​补件递交文书"
        case .resubmissionAfterRejection:
            return "​拒签递交文书"
        }
    }
    
}
