//
//  YHSelectViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/11/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSelectViewModel: YHBaseViewModel {
    // 数据源
    var categoryArray: [YHSelectCategoryModel] = []
    var goodsArray: [YHSelectGoodsModel] = []
    var liveArr: [YHLiveModel] = []

}

extension YHSelectViewModel {
    func getCategoryList(callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.LiveSales.categoryList
        _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, _ in
            guard let self = self else { return }
            // 1. json字符串 转 对象
            if json.code == 200 {
                guard let dic = json.data?.peel as? [Any], let result = [YHSelectCategoryModel].deserialize(from: dic) else {
                    let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(false, error)
                    return
                }
                self.categoryArray = result
                callBackBlock(true, nil)
                
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func getGoodsList(categoryID: String, sortType: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["goods_category_id": categoryID, "page": 1, "page_size": 100, "sort_type": sortType]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.LiveSales.goodsList
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            guard let self = self else { return }
            // 1. json字符串 转 对象
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHSelectGoodModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.goodsArray = resultModel.list
                callBackBlock(true, nil)
                
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func getLiveList(callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.LiveSales.liveList
        _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, _ in
            guard let self = self else { return }
            // 1. json字符串 转 对象
            if json.code == 200 {
                guard let dic = json.data?.peel as? [Any], let result = [YHLiveModel].deserialize(from: dic) else {
                    let error = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    self.liveArr = []
                    callBackBlock(false, error)
                    return
                }
                self.liveArr = result
                callBackBlock(true, nil)
                
            } else {
                self.liveArr = []
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            self.liveArr = []
            callBackBlock(false, err)
        }
    }
}
