//
//  YHAIProductCell.swift
//  galaxy
//
//  Created by Dufet on 2024/11/27.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAIProductCell: UICollectionViewCell {

    static let cellReuseIdentifier = "YHAIProductCell"
    
    var model = YHEntranceconfigModel() {
        didSet {
            titleLabel.text = model.title
            subtitleLabel.text = model.description
            if !model.btnText.isEmpty {
                var text = model.btnText
                if text.count > 5 {
                    text = String(text.prefix(5))
                }
                blackTitleLabel.text = text
            } else {
                blackTitleLabel.text = "去了解"
            }
            bgImgView.sd_setImage(with: URL(string: model.cover), placeholderImage: UIImage(named: "ai_product_bg_default"))
        }
    }
    
    lazy var bgImgView: UIImageView = {
        let v = UIImageView(image: UIImage(named: "ai_product_bg_default"))
        return v
    }()
    
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_B(ofSize: 15)
        lable.text = "产品智能体"
        return lable
    }()
    
    lazy var subtitleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.init(hex: 0x8993A2)
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_R(ofSize: 12)
        lable.text = "银河在售商品介绍"
        return lable
    }()
    
    lazy var blackView: UIView = {
        
       let v = UIView()
        v.backgroundColor = .black
        v.layer.cornerRadius = 13.0
        v.clipsToBounds = true
        v.layer.allowsEdgeAntialiasing = true

        v.addSubview(blackTitleLabel)
        blackTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(10)
            make.right.equalTo(-10)
            make.top.bottom.equalToSuperview()
        }
        return v
    }()
    
    lazy var blackTitleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.white
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_M(ofSize: 11)
        lable.text = "去了解"
        return lable
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    func setupUI() {
        
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        
        contentView.addSubview(bgImgView)
        bgImgView.addSubview(titleLabel)
        bgImgView.addSubview(subtitleLabel)
        bgImgView.addSubview(blackView)
        
        bgImgView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.bottom.equalTo(0)
            make.top.equalTo(0)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(22)
            make.right.equalTo(-22)
            make.bottom.equalTo(subtitleLabel.snp.top).offset(-3)
            make.height.equalTo(20)
        }
        
        subtitleLabel.snp.makeConstraints { make in
            make.left.equalTo(22)
            make.right.equalTo(-22)
            make.bottom.equalTo(blackView.snp.top).offset(-12)
        }
        
        blackView.snp.makeConstraints { make in
            make.left.equalTo(22)
            make.bottom.equalTo(-24)
            make.height.equalTo(26)
            make.right.lessThanOrEqualTo(-22)
        }
    }
    
    func rotateToRight(_ isRotateRight: Bool) {
        
        let degree = isRotateRight ? 2.0 : -2.0
        let transform = CGAffineTransform(rotationAngle: CGFloat(degree * CGFloat.pi / 180)) // 2 度转换为弧度
        bgImgView.transform = transform
    }
}
