//
//  YHActivityDetailModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/6/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHActivityDetailModel: SmartCodable {

    var id: Int = 0        // 活动ID
    var tag: Int = 0       // 活动标签枚举 1：V专享
    var name: String = ""  // 活动标题
    var cover: String = "" // 活动封面
    var beginTime: String = "" // 开始时间戳
    var endTime: String = ""   // 结束时间戳
    var place: String = ""     // 活动地点
    var status: String = ""    // 活动的状态 1：立即报名 2：已报名 3：活动结束 4：已取消报名 5:已下架
    var checkId: String = ""   // 活动行程ID 仅当活动状态为2（已报名）时才大于0
    
    var tips: String = ""      // 温馨提示
    var guidance: String = "" // 交通引导
    var introduce: String = "" // 活动介绍
    var posters: [String] = [] // 活动海报
    
    var businessCardName: String = "" // 报名人姓名
    
    // 自定义
    var coverItems: [YHActivityCoverItem] = []
    
    required init() {
        
    }
    
    func getImageInfo() {
        self.coverItems.removeAll()
        coverItems.removeAll()
        for (_, url) in self.posters.enumerated() {
            let item = YHActivityCoverItem()
            item.url = url
            coverItems.append(item)
        }
    }
    
    private var beginTimeForUI: String = ""
    
    func getDateString(format: String = "MM/dd") -> String {
        if beginTimeForUI.isEmpty {
            
            if let tttt =  beginTime.double() {
                // 1.
                // 将时间戳转换为Date对象
                let date = Date(timeIntervalSince1970: TimeInterval(tttt))

                // 创建一个DateFormatter实例
                let dateFormatter = DateFormatter()

                // 设置日期格式，这里设置为"年-月-日 时:分:秒"
                dateFormatter.dateFormat = format // HH:mm:ss

                // 使用DateFormatter将Date对象转换为字符串
                let dateString = dateFormatter.string(from: date)
                
                dateFormatter.dateFormat = "HH:mm"
                let titmeString = dateFormatter.string(from: date)

                // 获取Calendar的当前实例
                let calendar = Calendar.current

                // 使用Calendar来获取星期几
                let weekday = calendar.component(.weekday, from: date)

                // 星期几的名称，根据weekday的值，1到7分别代表周一到周日
                if weekday > 0 && weekday < 8 {
                    let weekdayName = ["周日", "周一", "周二", "周三", "周四", "周五", "周六"][weekday - 1]
                    if let tttt =  endTime.double() {
                        // 将时间戳转换为Date对象
                        let date2 = Date(timeIntervalSince1970: TimeInterval(tttt))
                        let titmeString2 = dateFormatter.string(from: date2)
                        
                        if titmeString.contains(titmeString2) {
                            beginTimeForUI = dateString + " " + weekdayName + " " + titmeString
                        } else {
                            beginTimeForUI = dateString + " " + weekdayName + " " + titmeString + "-" + titmeString2
                        }

                    }
                }
            }
        }
        
        return beginTimeForUI
    }
}
