//
//  YHConfigModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/4/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHConfigModel: SmartCodable {
    var start_up_url: String = ""
    var countdown: Int = 0
    var oss_server: String = ""
    var article_h5_url: String = ""
    
    // 版本升级有关字段
    var min_version: String = ""
    var max_version: String = ""
    var suggest_updating: Bool = false
    var suggest_updating_msg: String = ""
    
    var is_integral_open: Bool = false // 条件控制哈 PingGuoShenHe  true - 展示  false - hidden
//    var is_recharge_order_open : Bool = false //双十一banner开关 //`is_recharge_order_open` int NOT NULL DEFAULT '0' COMMENT '1 开启 0关闭',
    // 人民币-港币的汇率
    var rate: String = ""
    var xiaobao_switch: Bool = false 
    
    required init() {
    }
}

class YHHomeInfoModel: SmartCodable {
    var king_kong_list: [YHHomeFourKingInfoModel] = []
    var tab_list: [YHHomeTabInfoModel] = []
    var live_info: YHHomeLiveInfoModel = YHHomeLiveInfoModel()
    required init() {
    }
}

class YHHomeFourKingInfoModel: SmartCodable {
    var id: Int = 0
    var img_url: String = ""
    var skip_type: Int = 0
    var sort_num: Int = 0
    required init() {
    }
}

class YHHomeTabInfoModel: SmartCodable {
    var id: Int = 0
    var title: String = ""
    var name: String = ""
    var sort_num: Int = 0
    required init() {
    }
}

class YHHomeLiveInfoModel: SmartCodable {
    var id: Int = 0
    var status: Int = 0
    var app_id: String = ""
    var token: String = ""
    var rtmp_channel: String = ""
    var img_url: String = ""
    var user_id: Int = 0
    required init() {
    }
}
