//
//  YHPlanScoreLevelTextView.swift
//  galaxy
//
//  Created by Dufet on 2025/3/28.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPlanScoreLevelTextItemView: UIView {
    
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = .mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_M(ofSize: 15)
        lable.text = ""
        return lable
    }()
    
    lazy var descLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = .init(hex: 0x6A7586)
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_R(ofSize: 13)
        lable.numberOfLines = 0
        lable.text = ""
        return lable
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
//        self.backgroundColor = .init(hex: 0x000000, alpha: 0.7)
        self.addSubview(titleLabel)
        self.addSubview(descLabel)

        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.top.equalTo(24)
            make.height.equalTo(20)
        }
        
        descLabel.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.equalTo(titleLabel.snp.bottom).offset(4)
            make.bottom.equalTo(0)
        }
    }
}

class YHPlanScoreLevelTextView: UIView {

    lazy var whiteContentView: UIView = {
        let v = UIView()
        v.backgroundColor = .white
        v.layer.cornerRadius = 6.0
        v.clipsToBounds = true
        return v
    }()
    
    lazy var titleLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = .mainTextColor
        lable.textAlignment = .center
        lable.font = UIFont.PFSC_M(ofSize: 17)
        lable.text = "续签评估等级说明"
        return lable
    }()
    
    lazy var lineView: UIView = {
        let v = UIView()
        v.backgroundColor = .init(hex: 0xE9ECF0)
        return v
    }()
    
    lazy var closeBtn: UIButton = {
        let btn = UIButton()
        btn.setImage(UIImage(named: "plan_score_level_close"), for: .normal)
        btn.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
        btn.YH_clickEdgeInsets = UIEdgeInsets(top: 20, left: 20, bottom: 20, right: 20)
        return btn
    }()
    
    lazy var item1View: YHPlanScoreLevelTextItemView = {
        let v = YHPlanScoreLevelTextItemView(frame: .zero)
        v.titleLabel.text = "强"
        v.descLabel.text = "与香港有强联系（长期居住、稳定工作/业务、家庭在港、子女本地就读等，续期资料完整度高）    "
        return v
    }()
    
    lazy var item2View: YHPlanScoreLevelTextItemView = {
        let v = YHPlanScoreLevelTextItemView(frame: .zero)
        v.titleLabel.text = "中"
        v.descLabel.text = "与香港有一定联系（有生活/工作联系但关联不是非常强,能提供个别续期所需的资料）"
        return v
    }()
    
    lazy var item3View: YHPlanScoreLevelTextItemView = {
        let v = YHPlanScoreLevelTextItemView(frame: .zero)
        v.titleLabel.text = "弱"
        v.descLabel.text = "与香港联系较弱（极少在港居住、无稳定工作或工作关联弱、无法证明贡献等，基本无法提供相应的续期资料）    "
        return v
    }()
    
    static func alertView() -> YHPlanScoreLevelTextView {
        let v = YHPlanScoreLevelTextView(frame: UIScreen.main.bounds)
        return v
    }
    
    @objc func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    @objc func dismiss() {
        DispatchQueue.main.async {
            self.removeFromSuperview()
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        self.backgroundColor = .init(hex: 0x000000, alpha: 0.7)
        self.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(lineView)
        whiteContentView.addSubview(closeBtn)
        whiteContentView.addSubview(item1View)
        whiteContentView.addSubview(item2View)
        whiteContentView.addSubview(item3View)

        whiteContentView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.bottom.equalTo(6)
            make.height.equalTo(450)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.top.equalTo(16)
            make.height.equalTo(24)
        }
        
        lineView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
            make.height.equalTo(0.5)
        }
        
        closeBtn.snp.makeConstraints { make in
            make.width.height.equalTo(24)
            make.centerY.equalTo(titleLabel)
            make.right.equalTo(-20)
        }
        
        item1View.snp.makeConstraints { make in
            make.top.equalTo(lineView.snp.bottom).offset(0)
            make.left.right.equalToSuperview()
        }
        
        item2View.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(item1View.snp.bottom).offset(3)
        }
        
        item3View.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(item2View.snp.bottom).offset(3)
        }
    }

}
