import { createStore } from 'vuex'

export default new createStore({
  state: {
    username: '',
    token: '',
    id: null,
    router: '',
    userinfo: ''
  },
  mutations: {
    setusername(state, value) {
      state.username = value
    },
    settoken(state, value) {
      state.token = value
    },
    setid(state, value) {
      state.id = value
    },
    setRouter(state, value) {
      state.router = value
    },
    setUsreInfo(state, value) {
      state.userinfo = value
    }
  },
  getters: {
    getUserInfo: state => {return state.userinfo},
    gettoken(state) {
      if (state.token == "" || state.token) {
        state.token = localStorage.getItem('token')
      }
      return state.token
    },
    getId: state => state.id,
    getRouter: state => {return state.router}
  },
})

